/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.model.Build;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsResultAction
implements StaplerProxy,
HealthReportingAction {
    private static final int HEIGHT = 200;
    private static final int WIDTH = 500;
    private static final long serialVersionUID = -5329651349674842873L;
    private final Build<?, ?> owner;
    private FindBugsResult result;
    private final int healthy;
    private final int unHealthy;
    private final boolean isHealthyReportEnabled;
    private final int minimumBugs;

    public FindBugsResultAction(Build<?, ?> owner, int minimumBugs, boolean isHealthyReportEnabled, int healthy, int unHealthy) {
        this.owner = owner;
        this.minimumBugs = minimumBugs;
        this.isHealthyReportEnabled = isHealthyReportEnabled;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
    }

    public Build<?, ?> getOwner() {
        return this.owner;
    }

    public Object getTarget() {
        return this.getResult();
    }

    public FindBugsResult getResult() {
        return this.result;
    }

    public HealthReport getBuildHealth() {
        if (this.isHealthyReportEnabled) {
            int numberOfWarnings = this.getResult().getNumberOfWarnings();
            int percentage = numberOfWarnings < this.healthy ? 100 : (numberOfWarnings > this.unHealthy ? 0 : 100 - (numberOfWarnings - this.healthy) * 100 / (this.unHealthy - this.healthy));
            return new HealthReport(percentage, "FindBugs: " + numberOfWarnings + " warnings found.");
        }
        return null;
    }

    public String getDisplayName() {
        return "FindBugs Results";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "findbugsResult";
    }

    public FindBugsResultAction getPreviousResult() {
        FindBugsResultAction previousBuild = this.getPreviousBuild();
        if (previousBuild == null) {
            throw new NoSuchElementException("There is no previous build for action " + this);
        }
        return previousBuild;
    }

    private FindBugsResultAction getPreviousBuild() {
        FindBugsResultAction action;
        AbstractBuild build = this.owner;
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (FindBugsResultAction)build.getAction(FindBugsResultAction.class)) == null);
        return action;
    }

    public boolean hasPreviousResult() {
        return this.getPreviousBuild() != null;
    }

    public void setResult(FindBugsResult result) {
        this.result = result;
    }

    public void doGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        if (request.checkIfModified(this.owner.getTimestamp(), response)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request), (int)500, (int)200);
    }

    private CategoryDataset buildDataSet(StaplerRequest request) {
        DataSetBuilder builder = new DataSetBuilder();
        for (FindBugsResultAction action = this; action != null; action = action.getPreviousBuild()) {
            int numberOfWarnings = action.getResult().getNumberOfWarnings();
            if (this.minimumBugs > 0) {
                if (numberOfWarnings > this.minimumBugs) {
                    builder.add((Number)this.minimumBugs, (Comparable)((Object)"threshold"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.owner));
                } else {
                    builder.add((Number)numberOfWarnings, (Comparable)((Object)"threshold"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.owner));
                }
            }
            if (numberOfWarnings > this.minimumBugs) {
                builder.add((Number)(numberOfWarnings - this.minimumBugs), (Comparable)((Object)"warnings"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.owner));
                continue;
            }
            builder.add((Number)0, (Comparable)((Object)"warnings"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.owner));
        }
        return builder.build();
    }

    private JFreeChart createChart(StaplerRequest request) {
        CategoryDataset dataset = this.buildDataSet(request);
        String relativePath = StringUtils.defaultIfEmpty((String)request.getParameter("rel"), (String)"");
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StackedAreaRenderer2 ar = new StackedAreaRenderer2();
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(1, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

