/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.model.Build;
import hudson.plugins.findbugs.JavaClass;
import hudson.plugins.findbugs.JavaProject;
import hudson.plugins.findbugs.Module;
import hudson.plugins.findbugs.Warning;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsCounter {
    private final Build<?, ?> build;

    public FindBugsCounter(Build<?, ?> build) {
        this.build = build;
    }

    protected Module parse(InputStream file) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(FindBugsCounter.class.getClassLoader());
        digester.addObjectCreate("BugCollection", Module.class);
        digester.addSetProperties("BugCollection");
        String classXpath = "BugCollection/file";
        digester.addObjectCreate(classXpath, JavaClass.class);
        digester.addSetProperties(classXpath);
        digester.addSetNext(classXpath, "addClass", JavaClass.class.getName());
        String warningXpath = "BugCollection/file/BugInstance";
        digester.addObjectCreate(warningXpath, Warning.class);
        digester.addSetProperties(warningXpath);
        digester.addSetNext(warningXpath, "addWarning", Warning.class.getName());
        return (Module)digester.parse(file);
    }

    public FilePath getWorkingDirectory() {
        return new FilePath(new File(this.build.getRootDir(), "findbugs-results"));
    }

    public JavaProject findBugs() throws IOException, InterruptedException, SAXException {
        FilePath[] list = this.getWorkingDirectory().list("*.xml");
        JavaProject project = new JavaProject();
        for (FilePath filePath : list) {
            Module module = this.parse(filePath.read());
            module.setName(StringUtils.substringBefore((String)filePath.getName(), (String)".xml"));
            project.addModule(module);
        }
        return project;
    }
}

