/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.findbugs.AbortException;
import hudson.plugins.findbugs.FindBugsCollector;
import hudson.plugins.findbugs.FindBugsCounter;
import hudson.plugins.findbugs.FindBugsDescriptor;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.JavaProject;
import hudson.tasks.Publisher;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsPublisher
extends Publisher {
    private static final String DEFAULT_PATTERN = "**/findbugs.xml";
    public static final FindBugsDescriptor FIND_BUGS_DESCRIPTOR = new FindBugsDescriptor();
    private final String pattern;
    private final String threshold;
    private boolean isThresholdEnabled;
    private int minimumBugs;
    private final String healthy;
    private final String unHealthy;
    private int healthyBugs;
    private int unHealthyBugs;
    private boolean isHealthyReportEnabled;

    public FindBugsPublisher(String pattern, String threshold, String healthy, String unHealthy) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.pattern = pattern;
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumBugs = Integer.valueOf(threshold);
                if (this.minimumBugs >= 0) {
                    this.isThresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyBugs = Integer.valueOf(healthy);
                this.unHealthyBugs = Integer.valueOf(unHealthy);
                if (this.healthyBugs >= 0 && this.unHealthyBugs > this.healthyBugs) {
                    this.isHealthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public Action getProjectAction(Project project) {
        return new FindBugsProjectAction(project);
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Collecting findbugs analysis files...");
        FindBugsCounter findBugsCounter = new FindBugsCounter(build);
        FilePath workingDirectory = findBugsCounter.getWorkingDirectory();
        workingDirectory.mkdirs();
        if (!this.copyFilesFromWorkspaceToBuild(build, listener, workingDirectory)) {
            return true;
        }
        try {
            JavaProject project = findBugsCounter.findBugs();
            FindBugsResultAction action = new FindBugsResultAction(build, this.minimumBugs, this.isHealthyReportEnabled, this.healthyBugs, this.unHealthyBugs);
            build.getActions().add(action);
            action.setResult(new FindBugsResult(build, project));
            int warnings = project.getNumberOfWarnings();
            if (warnings > 0) {
                listener.getLogger().println("A total of " + warnings + " potential bugs have been found.");
                if (this.isThresholdEnabled && warnings >= this.minimumBugs) {
                    build.setResult(Result.UNSTABLE);
                }
            } else {
                listener.getLogger().println("No potential bugs have been found.");
            }
        }
        catch (SAXException exception) {
            listener.getLogger().println();
            exception.printStackTrace(listener.fatalError("Could not parse FindBugs files. Please check if the file pattern is correct\nand the latest FindBugs scanner is used (i.e., maven-findbugs-plugin >= 1.1.1)"));
            build.setResult(Result.FAILURE);
            return true;
        }
        return false;
    }

    private boolean copyFilesFromWorkspaceToBuild(Build<?, ?> build, BuildListener listener, FilePath buildFolder) throws IOException, InterruptedException {
        try {
            ((Project)build.getProject()).getWorkspace().act((FilePath.FileCallable)new FindBugsCollector(listener, buildFolder, build.getTimestamp().getTimeInMillis(), StringUtils.defaultIfEmpty((String)this.pattern, (String)DEFAULT_PATTERN)));
            return true;
        }
        catch (AbortException exception) {
            listener.getLogger().println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return FIND_BUGS_DESCRIPTOR;
    }
}

