/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.Build;
import hudson.model.ModelObject;
import hudson.plugins.findbugs.FindBugsCounter;
import hudson.plugins.findbugs.FindBugsDetail;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.JavaProject;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsResult
implements ModelObject,
Serializable {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final Logger LOGGER = Logger.getLogger(FindBugsResult.class.getName());
    private final int delta;
    @SuppressWarnings(value={"Se"})
    private final Build<?, ?> owner;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    private final int numberOfWarnings;

    public FindBugsResult(Build<?, ?> build, JavaProject project) {
        this.owner = build;
        this.numberOfWarnings = project.getNumberOfWarnings();
        this.project = new WeakReference<JavaProject>(project);
        FindBugsResultAction action = (FindBugsResultAction)build.getAction(FindBugsResultAction.class);
        this.delta = action.hasPreviousResult() ? project.getNumberOfWarnings() - action.getPreviousResult().getResult().getNumberOfWarnings() : 0;
    }

    public String getDisplayName() {
        return "FindBugs Result";
    }

    public Build<?, ?> getOwner() {
        return this.owner;
    }

    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    public int getDelta() {
        return this.delta;
    }

    public JavaProject getProject() {
        try {
            JavaProject result;
            if (this.project == null) {
                this.loadResult();
            }
            if ((result = (JavaProject)this.project.get()) == null) {
                this.loadResult();
            }
            return (JavaProject)this.project.get();
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load FindBugs files.", exception);
        }
        catch (InterruptedException exception) {
            LOGGER.log(Level.WARNING, "Failed to load FindBugs files: operation has been canceled.", exception);
        }
        return new JavaProject();
    }

    private void loadResult() throws IOException, InterruptedException {
        try {
            JavaProject result = new FindBugsCounter(this.owner).findBugs();
            this.project = new WeakReference<JavaProject>(result);
        }
        catch (SAXException exception) {
            throw new IOException2((Throwable)exception);
        }
    }

    public FindBugsDetail getDynamic(String packageName, StaplerRequest request, StaplerResponse response) {
        return new FindBugsDetail(this.owner, this.getProject(), packageName);
    }

    public int getPreviousNumberOfWarnings(String packageName) {
        FindBugsResultAction action = (FindBugsResultAction)this.owner.getAction(FindBugsResultAction.class);
        if (action.hasPreviousResult()) {
            return action.getPreviousResult().getResult().getProject().getNumberOfWarnings(packageName);
        }
        return 0;
    }
}

