/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.model.AbstractBuild;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.util.AbstractResultAction;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.model.Priority;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsResultAction
extends AbstractResultAction<FindBugsResult> {
    private static final long serialVersionUID = -5329651349674842873L;
    private static final String FINDBUGS_RESULT_URL = "findbugsResult";

    public FindBugsResultAction(AbstractBuild<?, ?> owner, FindBugsResult result, HealthReportBuilder healthReportBuilder) {
        super(owner, healthReportBuilder, result);
    }

    @Override
    protected int getHealthCounter() {
        return ((FindBugsResult)this.getResult()).getNumberOfAnnotations();
    }

    public String getDisplayName() {
        return "FindBugs Result";
    }

    @Override
    public String getIconUrl() {
        return "/plugin/findbugs/icons/findbugs-32x32.gif";
    }

    public String getUrlName() {
        return FINDBUGS_RESULT_URL;
    }

    public FindBugsResultAction getPreviousResultAction() {
        FindBugsResultAction previousBuild = this.getPreviousBuild();
        if (previousBuild == null) {
            throw new NoSuchElementException("There is no previous build for action " + this);
        }
        return previousBuild;
    }

    private FindBugsResultAction getPreviousBuild() {
        FindBugsResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (FindBugsResultAction)build.getAction(FindBugsResultAction.class)) == null);
        return action;
    }

    @Override
    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    @Override
    protected JFreeChart createChart(StaplerRequest request, StaplerResponse response) {
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, FINDBUGS_RESULT_URL, this.buildDataSet(useHealthBuilder));
    }

    private CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (FindBugsResultAction action = this; action != null; action = action.getPreviousBuild()) {
            List<Object> series;
            FindBugsResult current = (FindBugsResult)action.getResult();
            if (current == null) continue;
            if (useHealthBuilder && this.getHealthReportBuilder().isEnabled()) {
                series = this.getHealthReportBuilder().createSeries(current.getNumberOfAnnotations());
            } else {
                series = new ArrayList<Integer>();
                series.add(current.getNumberOfAnnotations(Priority.HIGH));
                series.add(current.getNumberOfAnnotations(Priority.NORMAL));
                series.add(current.getNumberOfAnnotations(Priority.LOW));
            }
            int level = 0;
            for (Integer n : series) {
                builder.add((Number)n, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }
}

