/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.plugins.findbugs.FindBugsResult;

public final class ResultSummary {
    public static String createSummary(FindBugsResult result) {
        StringBuilder summary = new StringBuilder();
        int bugs = result.getNumberOfAnnotations();
        summary.append("FindBugs: ");
        if (bugs > 0) {
            summary.append("<a href=\"findbugsResult\">");
        }
        if (bugs == 1) {
            summary.append("1 warning");
        } else {
            summary.append(bugs + " warnings");
        }
        if (bugs > 0) {
            summary.append("</a>");
        }
        summary.append(" ");
        if (result.getNumberOfModules() > 1) {
            summary.append("in " + result.getNumberOfModules() + " FindBugs files.");
        } else {
            summary.append("in 1 FindBugs file.");
        }
        return summary.toString();
    }

    public static String createDeltaMessage(FindBugsResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"findbugsResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append("1 new warning");
            } else {
                summary.append(result.getNumberOfNewWarnings() + " new warnings");
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"findbugsResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append("1 fixed warning");
            } else {
                summary.append(result.getNumberOfFixedWarnings() + " fixed warnings");
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

