/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFinder
implements FilePath.FileCallable<String[]> {
    private static final long serialVersionUID = 2970029366847565970L;
    private static final String JAVA_PATTERN = "**/*.java";
    private final String pattern;

    public FileFinder() {
        this(JAVA_PATTERN);
    }

    public FileFinder(String pattern) {
        this.pattern = pattern;
    }

    public String[] invoke(File workspace, VirtualChannel channel) throws IOException {
        return this.find(workspace);
    }

    public String[] find(File workspace) {
        try {
            FileSet fileSet = new FileSet();
            Project antProject = new Project();
            fileSet.setProject(antProject);
            fileSet.setDir(workspace);
            fileSet.setIncludes(this.pattern);
            return fileSet.getDirectoryScanner(antProject).getIncludedFiles();
        }
        catch (BuildException exception) {
            return new String[0];
        }
    }
}

