/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import hudson.plugins.findbugs.FindBugsMessages;
import hudson.plugins.findbugs.util.model.AbstractAnnotation;
import hudson.plugins.findbugs.util.model.Priority;
import org.apache.commons.lang.StringUtils;

public class Bug
extends AbstractAnnotation {
    private static final long serialVersionUID = 5171661552905752370L;
    private String tooltip = "";
    private String instanceHash;

    public Bug(Priority priority, String message, String category, String type, int start, int end) {
        super(priority, message, start, end, category, type);
    }

    public Bug(Priority priority, String message, String category, String type, int lineNumber) {
        this(priority, message, category, type, lineNumber, lineNumber);
    }

    public Bug(Priority priority, String message, String category, String type) {
        this(priority, message, category, type, 0, 0);
    }

    public Bug(Priority priority, String message, String category, String type, int start, int end, String tooltip) {
        this(priority, message, category, type, start, end);
        this.tooltip = tooltip;
    }

    private Object readResolve() {
        if (this.instanceHash == null) {
            this.instanceHash = String.valueOf(super.hashCode());
        }
        return this;
    }

    public String getToolTip() {
        return StringUtils.defaultIfEmpty((String)this.tooltip, (String)FindBugsMessages.getInstance().getMessage(this.getType()));
    }

    public void setInstanceHash(String instanceHash) {
        this.instanceHash = instanceHash;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.instanceHash == null ? 0 : this.instanceHash.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bug other = (Bug)obj;
        return !(this.instanceHash == null ? other.instanceHash != null : !this.instanceHash.equals(other.instanceHash));
    }
}

