/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.plugins.findbugs.parser.NativeFindBugsParser;
import hudson.plugins.findbugs.parser.maven.MavenFindBugsParser;
import hudson.plugins.findbugs.util.AnnotationParser;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsParser
implements AnnotationParser {
    private static final long serialVersionUID = 8306319007761954027L;
    private final FilePath workspace;
    @SuppressWarnings(value={"Se"})
    private final Collection<String> mavenSources;

    public FindBugsParser(FilePath workspace) {
        this(workspace, new ArrayList<String>());
    }

    public FindBugsParser(FilePath workspace, Collection<String> mavenSources) {
        this.workspace = workspace;
        this.mavenSources = new ArrayList<String>(mavenSources);
    }

    @Override
    public String getName() {
        return "FINDBUGS";
    }

    @Override
    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        try {
            MavenFindBugsParser mavenFindBugsParser = new MavenFindBugsParser();
            if (mavenFindBugsParser.accepts(new FileInputStream(file))) {
                return mavenFindBugsParser.parse(new FileInputStream(file), moduleName, this.workspace);
            }
            ArrayList<String> sources = new ArrayList<String>(this.mavenSources);
            if (sources.isEmpty()) {
                String moduleRoot = StringUtils.substringBefore((String)file.getAbsolutePath().replace('\\', '/'), (String)"/target/");
                sources.add(moduleRoot + "/src/main/java");
                sources.add(moduleRoot + "/src/test/java");
                sources.add(moduleRoot + "/src");
            }
            return new NativeFindBugsParser().parse(file, sources, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (DocumentException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    @Override
    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        throw new UnsupportedOperationException("FinBugs parser does not parse input streams.");
    }
}

