/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.plugins.findbugs.util.FileFinder;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserResult
implements Serializable {
    private static final long serialVersionUID = -8414545334379193330L;
    @SuppressWarnings(value={"Se"})
    private final List<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
    @SuppressWarnings(value={"Se"})
    private final List<String> errorMessages = new ArrayList<String>();
    @SuppressWarnings(value={"Se"})
    private final Map<Priority, Integer> annotationCountByPriority = new HashMap<Priority, Integer>();
    @SuppressWarnings(value={"Se"})
    private final Set<String> modules = new HashSet<String>();
    private final FilePath workspace;

    public ParserResult() {
        this(null);
    }

    public ParserResult(FilePath workspace) {
        this.workspace = workspace;
        Priority[] priorities = Priority.values();
        for (int priority = 0; priority < priorities.length; ++priority) {
            this.annotationCountByPriority.put(priorities[priority], 0);
        }
    }

    public void findRelativeFile(FileAnnotation annotation) {
        try {
            String[] results;
            if (this.workspace != null && this.hasRelativeFileName(annotation) && (results = (String[])this.workspace.act((FilePath.FileCallable)new FileFinder("**/" + annotation.getFileName()))).length == 1) {
                annotation.setFileName(this.workspace.getRemote() + "/" + results[0]);
            }
        }
        catch (IOException exception) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean hasRelativeFileName(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        return !fileName.startsWith("/") && !fileName.contains(":");
    }

    public void addAnnotation(FileAnnotation annotation) {
        this.annotations.add(annotation);
        this.findRelativeFile(annotation);
        Integer count = this.annotationCountByPriority.get((Object)annotation.getPriority());
        this.annotationCountByPriority.put(annotation.getPriority(), count + 1);
    }

    public final void addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        for (FileAnnotation fileAnnotation : newAnnotations) {
            this.addAnnotation(fileAnnotation);
        }
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public Collection<String> getErrorMessages() {
        return Collections.unmodifiableList(this.errorMessages);
    }

    public Collection<FileAnnotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public int getNumberOfAnnotations(Priority priority) {
        return this.annotationCountByPriority.get((Object)priority);
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public boolean hasAnnotations(Priority priority) {
        return this.annotationCountByPriority.get((Object)priority) > 0;
    }

    public boolean hasNoAnnotations() {
        return !this.hasAnnotations();
    }

    public boolean hasNoAnnotations(Priority priority) {
        return !this.hasAnnotations(priority);
    }

    public int getNumberOfModules() {
        return this.modules.size();
    }

    public Set<String> getModules() {
        return Collections.unmodifiableSet(this.modules);
    }

    public void addModule(String moduleName) {
        this.modules.add(moduleName);
    }

    public void addModules(Collection<String> additionalModules) {
        this.modules.addAll(additionalModules);
    }
}

