/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsReporterDescriptor;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.parser.FindBugsCollector;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.model.JavaProject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public class FindBugsReporter
extends MavenReporter {
    public static final FindBugsReporterDescriptor FINDBUGS_SCANNER_DESCRIPTOR = new FindBugsReporterDescriptor();
    private static final String DEFAULT_PATTERN = "**/findbugsXml.xml";
    private final String pattern;
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;

    public FindBugsReporter(String pattern, String threshold, String healthy, String unHealthy) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.pattern = pattern;
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumAnnotations = Integer.valueOf(threshold);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthy);
                this.unHealthyAnnotations = Integer.valueOf(unHealthy);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!"findbugs".equals(mojo.getGoal())) {
            return true;
        }
        FilePath pomPath = new FilePath(pom.getBasedir());
        FindBugsCollector findBugsCollector = new FindBugsCollector(listener.getLogger(), build.getTimestamp().getTimeInMillis(), StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN));
        final JavaProject project = (JavaProject)pomPath.act((FilePath.FileCallable)findBugsCollector);
        build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){

            public Void call(MavenBuild build) throws IOException, InterruptedException {
                AbstractBuild previousBuild;
                FindBugsResultAction previousAction;
                Run previous = build.getPreviousBuild();
                FindBugsResult result = previous instanceof AbstractBuild ? ((previousAction = (FindBugsResultAction)(previousBuild = (AbstractBuild)previous).getAction(FindBugsResultAction.class)) == null ? new FindBugsResult((AbstractBuild<?, ?>)build, project) : new FindBugsResult((AbstractBuild<?, ?>)build, project, ((FindBugsResult)previousAction.getResult()).getProject(), ((FindBugsResult)previousAction.getResult()).getZeroWarningsHighScore())) : new FindBugsResult((AbstractBuild<?, ?>)build, project);
                HealthReportBuilder healthReportBuilder = new HealthReportBuilder(FindBugsReporter.this.thresholdEnabled, FindBugsReporter.this.minimumAnnotations, FindBugsReporter.this.healthyReportEnabled, FindBugsReporter.this.healthyAnnotations, FindBugsReporter.this.unHealthyAnnotations, Messages.FindBugs_ResultAction_HealthReportSingleItem(), Messages.FindBugs_ResultAction_HealthReportMultipleItem("%d"));
                build.getActions().add(new FindBugsResultAction((AbstractBuild<?, ?>)build, result, healthReportBuilder));
                build.registerAsProjectAction((MavenReporter)FindBugsReporter.this);
                return null;
            }
        });
        int warnings = project.getNumberOfAnnotations();
        if (warnings > 0) {
            listener.getLogger().println("A total of " + warnings + " potential bugs have been found.");
            if (this.thresholdEnabled && warnings >= this.minimumAnnotations) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            listener.getLogger().println("No potential bugs have been found.");
        }
        return true;
    }

    public Action getProjectAction(MavenModule module) {
        return new FindBugsProjectAction((AbstractProject<?, ?>)module);
    }

    public MavenReporterDescriptor getDescriptor() {
        return FINDBUGS_SCANNER_DESCRIPTOR;
    }
}

