/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser.maven;

import hudson.FilePath;
import hudson.plugins.findbugs.parser.Bug;
import hudson.plugins.findbugs.parser.maven.BugCollection;
import hudson.plugins.findbugs.parser.maven.BugInstance;
import hudson.plugins.findbugs.parser.maven.File;
import hudson.plugins.findbugs.parser.maven.JavaFileFinder;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.plugins.findbugs.util.model.Priority;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class MavenFindBugsParser {
    public boolean accepts(InputStream file) {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(MavenFindBugsParser.class.getClassLoader());
            digester.addObjectCreate("BugCollection/file/BugInstance", BugCollection.class);
            BugCollection module = (BugCollection)digester.parse(file);
            return module != null;
        }
        catch (IOException exception) {
            return false;
        }
        catch (SAXException exception) {
            return false;
        }
    }

    public MavenModule parse(InputStream file, String moduleName, java.io.File workspace) throws IOException, SAXException, InterruptedException {
        MavenModule mavenModule = this.parse(file, moduleName);
        String[] files = (String[])new FilePath(workspace).act((FilePath.FileCallable)new JavaFileFinder());
        this.mapFiles(mavenModule, files);
        return mavenModule;
    }

    public void mapFiles(MavenModule mavenModule, String[] files) {
        String key;
        HashMap<String, String> fileMapping = new HashMap<String, String>();
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].replace('/', '.').replace('\\', '.');
            if (name.contains(".src.main.java.")) {
                key = StringUtils.substringAfterLast((String)name, (String)"src.main.java.");
                fileMapping.put(key, files[i]);
                continue;
            }
            if (name.contains(".src.test.java.")) {
                key = StringUtils.substringAfterLast((String)name, (String)"src.test.java.");
                fileMapping.put(key, files[i]);
                continue;
            }
            if (!name.contains(".src.")) continue;
            key = StringUtils.substringAfterLast((String)name, (String)"src.");
            fileMapping.put(key, files[i]);
        }
        for (FileAnnotation annotation : mavenModule.getAnnotations()) {
            key = StringUtils.substringBeforeLast((String)(annotation.getPackageName() + "." + annotation.getFileName()), (String)"$") + ".java";
            if (!fileMapping.containsKey(key) || !(annotation instanceof Bug)) continue;
            ((Bug)annotation).setFileName((String)fileMapping.get(key));
        }
    }

    public MavenModule parse(InputStream file, String moduleName) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(MavenFindBugsParser.class.getClassLoader());
        String rootXPath = "BugCollection";
        digester.addObjectCreate(rootXPath, BugCollection.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = "BugCollection/file";
        digester.addObjectCreate(fileXPath, File.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addFile", File.class.getName());
        String bugXPath = "BugCollection/file/BugInstance";
        digester.addObjectCreate(bugXPath, BugInstance.class);
        digester.addSetProperties(bugXPath, "lineNumber", "lineNumberExpression");
        digester.addSetNext(bugXPath, "addBugInstance", BugInstance.class.getName());
        BugCollection module = (BugCollection)digester.parse(file);
        if (module == null) {
            throw new SAXException("Input stream is not in maven-findbugs-plugin format.");
        }
        return this.convert(module, moduleName);
    }

    private MavenModule convert(BugCollection collection, String moduleName) {
        MavenModule module = new MavenModule(moduleName);
        for (File file : collection.getFiles()) {
            for (BugInstance warning : file.getBugInstances()) {
                Priority priority = Priority.valueOf(StringUtils.upperCase((String)warning.getPriority()));
                Bug bug = new Bug(priority, warning.getMessage(), warning.getCategory(), warning.getType(), warning.getStart(), warning.getEnd());
                bug.setPackageName(StringUtils.substringBeforeLast((String)file.getClassname(), (String)"."));
                bug.setModuleName(moduleName);
                bug.setFileName(StringUtils.substringAfterLast((String)file.getClassname(), (String)"."));
                module.addAnnotation(bug);
            }
        }
        return module;
    }
}

