/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.util;

import de.java2html.converter.JavaSource2HTMLConverter;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.JavaSourceConversionOptions;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.findbugs.util.model.FileAnnotation;
import hudson.plugins.findbugs.util.model.LineRange;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDetail
implements ModelObject {
    protected static final int SOURCE_GENERATOR_OFFSET = 13;
    private static final String FIRST_COLOR = "#FCAF3E";
    private static final String OTHER_COLOR = "#FCE94F";
    private final AbstractBuild<?, ?> owner;
    private final String fileName;
    private final FileAnnotation annotation;
    private String sourceCode = "";

    public SourceDetail(AbstractBuild<?, ?> owner, FileAnnotation annotation) {
        this.owner = owner;
        this.annotation = annotation;
        this.fileName = StringUtils.substringAfterLast((String)annotation.getFileName(), (String)"/");
        this.initializeContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeContent() {
        InputStream file = null;
        try {
            String linkName = this.annotation.getFileName();
            file = linkName.startsWith("/") || linkName.contains(":") || this.owner == null ? new FileInputStream(new File(linkName)) : this.owner.getProject().getWorkspace().child(linkName).read();
            this.splitSourceFile(this.highlightSource(file));
        }
        catch (IOException exception) {
            try {
                this.sourceCode = "Can't read file: " + exception.getLocalizedMessage();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(file);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)file);
        }
        IOUtils.closeQuietly((InputStream)file);
    }

    public String getDisplayName() {
        return this.fileName;
    }

    public final String highlightSource(InputStream file) throws IOException {
        JavaSource source = new JavaSourceParser().parse(file);
        JavaSource2HTMLConverter converter = new JavaSource2HTMLConverter();
        StringWriter writer = new StringWriter();
        JavaSourceConversionOptions options = JavaSourceConversionOptions.getDefault();
        options.setShowLineNumbers(true);
        options.setAddLineAnchors(true);
        converter.convert(source, options, (Writer)writer);
        return writer.toString();
    }

    public final void splitSourceFile(String sourceFile) {
        StringBuilder output = new StringBuilder(sourceFile.length());
        LineIterator lineIterator = IOUtils.lineIterator((Reader)new StringReader(sourceFile));
        try {
            int lineNumber;
            for (lineNumber = 1; lineNumber < 13; ++lineNumber) {
                output.append(lineIterator.nextLine());
                output.append("\n");
            }
            lineNumber = 1;
            int ranges = 1;
            for (LineRange range : this.annotation.getLineRanges()) {
                while (lineNumber < range.getStart()) {
                    output.append(lineIterator.nextLine());
                    output.append("\n");
                    ++lineNumber;
                }
                output.append("</code>\n");
                output.append("</td></tr>\n");
                output.append("<tr><td bgcolor=\"");
                if (ranges == 1) {
                    output.append(FIRST_COLOR);
                } else {
                    output.append(OTHER_COLOR);
                }
                output.append("\">\n");
                output.append("<div tooltip=\"");
                if (range.getStart() > 0) {
                    output.append(StringEscapeUtils.escapeHtml((String)this.annotation.getMessage()));
                }
                output.append(StringEscapeUtils.escapeHtml((String)this.annotation.getToolTip()));
                output.append("\" nodismiss=\"\">\n");
                output.append("<code><b>\n");
                if (range.getStart() <= 0) {
                    output.append(this.annotation.getMessage());
                    if (StringUtils.isBlank((String)this.annotation.getMessage())) {
                        output.append(this.annotation.getToolTip());
                    }
                } else {
                    while (lineNumber <= range.getEnd()) {
                        output.append(lineIterator.nextLine());
                        output.append("\n");
                        ++lineNumber;
                    }
                }
                output.append("</b></code>\n");
                output.append("</div>\n");
                output.append("</td></tr>\n");
                output.append("<tr><td>\n");
                output.append("<code>\n");
                ++ranges;
            }
            while (lineIterator.hasNext()) {
                output.append(lineIterator.nextLine());
                output.append("\n");
            }
        }
        catch (NoSuchElementException exception) {
            // empty catch block
        }
        this.sourceCode = output.toString();
    }

    public String getFileName() {
        return this.fileName;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }
}

