/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.findbugs.FindBugsProjectAction;
import hudson.plugins.findbugs.FindBugsPublisher;
import hudson.plugins.findbugs.FindBugsReporterDescriptor;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.FindBugsResultBuilder;
import hudson.plugins.findbugs.MavenFindBugsResultAction;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.parser.FindBugsCollector;
import hudson.plugins.findbugs.parser.PlainFindBugsParser;
import hudson.plugins.findbugs.util.HealthAwareMavenReporter;
import hudson.plugins.findbugs.util.HealthReportBuilder;
import hudson.plugins.findbugs.util.model.JavaProject;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = -288391908253344862L;
    public static final FindBugsReporterDescriptor FINDBUGS_SCANNER_DESCRIPTOR = new FindBugsReporterDescriptor(FindBugsPublisher.FIND_BUGS_DESCRIPTOR);
    private static final String FINDBUGS_XML_FILE = "findbugsXml.xml";
    private static final String MAVEN_FINDBUGS_XML_FILE = "findbugs.xml";
    private String pattern;
    private transient Object lockLibraryInitialization = new Object();
    private transient boolean isInitialized;

    @DataBoundConstructor
    public FindBugsReporter(String threshold, String healthy, String unHealthy, String height) {
        super(threshold, healthy, unHealthy, height, "FINDBUGS");
    }

    private Object readResolve() {
        this.lockLibraryInitialization = new Object();
        this.isInitialized = false;
        return this;
    }

    @Override
    protected boolean acceptGoal(String goal) {
        return "findbugs".equals(goal) || "site".equals(goal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaProject perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PrintStream logger) throws InterruptedException, IOException {
        Object object = this.lockLibraryInitialization;
        synchronized (object) {
            if (!this.isInitialized) {
                this.initializeFindBugsLibrary(build);
                this.isInitialized = true;
            }
        }
        FindBugsCollector findBugsCollector = new FindBugsCollector(logger, this.determineFileName(mojo), false);
        return (JavaProject)this.getTargetPath(pom).act((FilePath.FileCallable)findBugsCollector);
    }

    @Override
    protected void persistResult(JavaProject project, MavenBuild build) {
        FindBugsResult result = new FindBugsResultBuilder().build((AbstractBuild<?, ?>)build, project);
        HealthReportBuilder healthReportBuilder = this.createHealthBuilder(Messages.FindBugs_ResultAction_HealthReportSingleItem(), Messages.FindBugs_ResultAction_HealthReportMultipleItem("%d"));
        build.getActions().add(new MavenFindBugsResultAction((AbstractBuild<?, ?>)build, healthReportBuilder, this.getHeight(), result));
        build.registerAsProjectAction((MavenReporter)this);
    }

    private String determineFileName(MojoInfo mojo) {
        String fileName = MAVEN_FINDBUGS_XML_FILE;
        try {
            Boolean isNativeFormat = (Boolean)mojo.getConfigurationValue("findbugsXmlOutput", Boolean.class);
            if (Boolean.TRUE.equals(isNativeFormat)) {
                fileName = FINDBUGS_XML_FILE;
            }
        }
        catch (ComponentConfigurationException componentConfigurationException) {
            // empty catch block
        }
        return fileName;
    }

    private void initializeFindBugsLibrary(MavenBuildProxy build) throws IOException, InterruptedException {
        DetectorFactoryCollection.rawInstance().setPluginList((URL[])build.execute((MavenBuildProxy.BuildCallable)new FindBugsLibraryUrlDetector()));
    }

    public Action getProjectAction(MavenModule module) {
        return new FindBugsProjectAction((AbstractProject<?, ?>)module, this.getTrendHeight());
    }

    @Override
    protected Class<? extends Action> getResultActionClass() {
        return MavenFindBugsResultAction.class;
    }

    public MavenReporterDescriptor getDescriptor() {
        return FINDBUGS_SCANNER_DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FindBugsLibraryUrlDetector
    implements MavenBuildProxy.BuildCallable<URL[], IOException> {
        private static final long serialVersionUID = 8714527548935228652L;

        private FindBugsLibraryUrlDetector() {
        }

        public URL[] call(MavenBuild mavenBuild) throws IOException, InterruptedException {
            return PlainFindBugsParser.createPluginUrls();
        }
    }
}

