/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.parser;

import hudson.FilePath;
import hudson.plugins.findbugs.Messages;
import hudson.plugins.findbugs.parser.NativeFindBugsParser;
import hudson.plugins.findbugs.parser.PlainFindBugsParser;
import hudson.plugins.findbugs.parser.maven.MavenFindBugsParser;
import hudson.plugins.findbugs.util.ModuleDetector;
import hudson.plugins.findbugs.util.model.JavaProject;
import hudson.plugins.findbugs.util.model.MavenModule;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsCollector
implements FilePath.FileCallable<JavaProject> {
    private static final long serialVersionUID = -6415863872891783891L;
    private final transient PrintStream logger;
    private final String filePattern;
    private final boolean autoInitializeFindBugs;

    public FindBugsCollector(PrintStream listener, String filePattern, boolean autoInitializeFindBugs) {
        this.logger = listener;
        this.filePattern = filePattern;
        this.autoInitializeFindBugs = autoInitializeFindBugs;
    }

    protected void log(String message) {
        if (this.logger != null) {
            this.logger.println("[FINDBUGS] " + message);
        }
    }

    public JavaProject invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] findBugsFiles = this.findFindBugsFiles(workspace);
        JavaProject project = new JavaProject();
        if (findBugsFiles.length == 0) {
            project.setError("No findbugs report files were found. Configuration error?");
            return project;
        }
        try {
            ModuleDetector moduleDetector = new ModuleDetector();
            int duplicateModuleCounter = 1;
            for (String file : findBugsFiles) {
                String message;
                File findbugsFile = new File(workspace, file);
                String moduleName = moduleDetector.guessModuleName(findbugsFile.getAbsolutePath());
                if (project.containsModule(moduleName)) {
                    moduleName = moduleName + "-" + duplicateModuleCounter++;
                }
                MavenModule module = new MavenModule(moduleName);
                if (!findbugsFile.canRead()) {
                    message = Messages.FindBugs_FindBugsCollector_Error_NoPermission(findbugsFile);
                    this.log(message);
                    module.setError(message);
                    continue;
                }
                if (new FilePath(findbugsFile).length() <= 0L) {
                    message = Messages.FindBugs_FindBugsCollector_Error_EmptyFile(findbugsFile);
                    this.log(message);
                    module.setError(message);
                    continue;
                }
                module = this.parseFile(workspace, findbugsFile, module);
                project.addModule(module);
            }
        }
        catch (InterruptedException exception) {
            this.log("Parsing has been canceled.");
        }
        return project;
    }

    private MavenModule parseFile(File workspace, File findbugsFile, MavenModule emptyModule) throws InterruptedException {
        Throwable exception = null;
        MavenModule module = emptyModule;
        try {
            FilePath filePath = new FilePath(findbugsFile);
            MavenFindBugsParser mavenFindBugsParser = new MavenFindBugsParser();
            if (mavenFindBugsParser.accepts(filePath.read())) {
                this.log("Activating deprecated FindBugs parser (maven-findbugs-plugin <= 1.1.1)");
                module = mavenFindBugsParser.parse(filePath.read(), emptyModule.getName(), workspace);
                module.setError(Messages.FindBugs_FindBugsCollector_Error_OldMavenPlugin(findbugsFile));
            } else {
                this.log("Activating up-to-date parser (maven-findbugs-plugin >= 1.2 or ant).");
                PlainFindBugsParser parser = this.autoInitializeFindBugs ? new NativeFindBugsParser() : new PlainFindBugsParser();
                String moduleRoot = StringUtils.substringBefore((String)findbugsFile.getPath().replace('\\', '/'), (String)"/target/");
                module = parser.parse(filePath.read(), moduleRoot, emptyModule.getName());
            }
            this.log("Successfully parsed findbugs file " + findbugsFile + " of module " + module.getName() + " with " + module.getNumberOfAnnotations() + " warnings.");
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (DocumentException e) {
            exception = e;
        }
        if (exception != null) {
            String errorMessage = Messages.FindBugs_FindBugsCollector_Error_Exception(findbugsFile) + "\n\n" + ExceptionUtils.getStackTrace((Throwable)exception);
            this.log(errorMessage);
            module.setError(errorMessage);
        }
        return module;
    }

    private String[] findFindBugsFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

