/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.findbugs.dashboard;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.graph.CategoryBuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.BoxRenderer;
import hudson.plugins.analysis.util.CategoryUrlBuilder;
import hudson.plugins.analysis.util.SerializableToolTipGenerator;
import hudson.plugins.analysis.util.SerializableUrlGenerator;
import hudson.plugins.analysis.util.ToolTipBoxRenderer;
import hudson.plugins.analysis.util.ToolTipBuilder;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.plugins.findbugs.FindBugsResult;
import hudson.plugins.findbugs.Messages;
import hudson.util.ColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindbugsEvaluationsGraph
extends CategoryBuildResultGraph {
    public String getId() {
        return "EVALS";
    }

    public String getLabel() {
        return Messages.FindBugs_EvaluationsGraph_title();
    }

    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        if (current instanceof FindBugsResult) {
            FindBugsResult findBugsResult = (FindBugsResult)current;
            series.add(findBugsResult.getNumberOfComments());
        }
        return series;
    }

    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createBlockChart(dataSet);
    }

    protected Color[] getColors() {
        return new Color[]{ColorPalette.RED, ColorPalette.BLUE};
    }

    @SuppressWarnings(value={"SIC"})
    protected CategoryItemRenderer createRenderer(GraphConfiguration configuration, String pluginName, ToolTipProvider toolTipProvider) {
        CategoryUrlBuilder url = new CategoryUrlBuilder(this.getRootUrl(), pluginName){

            protected String getDetailUrl(int row) {
                if (row == 1) {
                    return "fixed";
                }
                return "new";
            }
        };
        ToolTipBuilder toolTip = new ToolTipBuilder(toolTipProvider){

            protected String getShortDescription(int row) {
                if (row == 1) {
                    return hudson.plugins.analysis.Messages.Trend_Fixed();
                }
                return hudson.plugins.analysis.Messages.Trend_New();
            }
        };
        if (configuration.useBuildDateAsDomain()) {
            return new ToolTipBoxRenderer((SerializableToolTipGenerator)toolTip);
        }
        return new BoxRenderer((SerializableUrlGenerator)url, (SerializableToolTipGenerator)toolTip);
    }
}

