/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReflectionConverter
implements Converter {
    protected final ReflectionProvider reflectionProvider;
    protected final Mapper mapper;
    protected transient SerializationMethodInvoker serializationMethodInvoker;
    private transient ReflectionProvider pureJavaReflectionProvider;

    public AbstractReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
    }

    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        Object source = this.serializationMethodInvoker.callWriteReplace(original);
        if (source.getClass() != original.getClass()) {
            String attributeName = this.mapper.aliasForSystemAttribute("resolves-to");
            if (attributeName != null) {
                writer.addAttribute(attributeName, this.mapper.serializedClass(source.getClass()));
            }
            context.convertAnother(source);
        } else {
            this.doMarshal(source, writer, context);
        }
    }

    protected void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final HashSet seenFields = new HashSet();
        final HashMap defaultFieldDefinition = new HashMap();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class type, Class definedIn, Object value) {
                SingleValueConverter converter;
                if (!AbstractReflectionConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                    return;
                }
                if (!defaultFieldDefinition.containsKey(fieldName)) {
                    Class<?> lookupType = source.getClass();
                    defaultFieldDefinition.put(fieldName, AbstractReflectionConverter.this.reflectionProvider.getField(lookupType, fieldName));
                }
                if ((converter = AbstractReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type, definedIn)) != null) {
                    if (value != null) {
                        if (seenFields.contains(fieldName)) {
                            throw new ConversionException("Cannot write field with name '" + fieldName + "' twice as attribute for object of type " + source.getClass().getName());
                        }
                        String str = converter.toString(value);
                        if (str != null) {
                            writer.addAttribute(AbstractReflectionConverter.this.mapper.aliasForAttribute(AbstractReflectionConverter.this.mapper.serializedMember(definedIn, fieldName)), str);
                        }
                    }
                    seenFields.add(fieldName);
                }
            }
        });
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                if (!AbstractReflectionConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                    return;
                }
                if (!seenFields.contains(fieldName) && newObj != null) {
                    Mapper.ImplicitCollectionMapping mapping = AbstractReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), fieldName);
                    if (mapping != null) {
                        if (mapping.getItemFieldName() != null) {
                            Collection list = (Collection)newObj;
                            for (Object obj : list) {
                                this.writeField(fieldName, obj == null ? AbstractReflectionConverter.this.mapper.serializedClass(null) : mapping.getItemFieldName(), mapping.getItemType(), definedIn, obj);
                            }
                        } else {
                            context.convertAnother(newObj);
                        }
                    } else {
                        this.writeField(fieldName, null, fieldType, definedIn, newObj);
                    }
                }
            }

            private void writeField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                ExtendedHierarchicalStreamWriterHelper.startNode(writer, aliasName != null ? aliasName : AbstractReflectionConverter.this.mapper.serializedMember(source.getClass(), fieldName), fieldType);
                if (newObj != null) {
                    Field defaultField;
                    String attributeName;
                    String serializedClassName;
                    Class defaultType;
                    Class<?> actualType = newObj.getClass();
                    if (!actualType.equals(defaultType = AbstractReflectionConverter.this.mapper.defaultImplementationOf(fieldType)) && !(serializedClassName = AbstractReflectionConverter.this.mapper.serializedClass(actualType)).equals(AbstractReflectionConverter.this.mapper.serializedClass(defaultType)) && (attributeName = AbstractReflectionConverter.this.mapper.aliasForSystemAttribute("class")) != null) {
                        writer.addAttribute(attributeName, serializedClassName);
                    }
                    if ((defaultField = (Field)defaultFieldDefinition.get(fieldName)).getDeclaringClass() != definedIn && (attributeName = AbstractReflectionConverter.this.mapper.aliasForSystemAttribute("defined-in")) != null) {
                        writer.addAttribute(attributeName, AbstractReflectionConverter.this.mapper.serializedClass(definedIn));
                    }
                    Field field = AbstractReflectionConverter.this.reflectionProvider.getField(definedIn, fieldName);
                    AbstractReflectionConverter.this.marshallField(context, newObj, field);
                }
                writer.endNode();
            }
        });
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        context.convertAnother(newObj, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(reader, context);
        result = this.doUnmarshal(result, reader, context);
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object value;
        Class type;
        SeenFields seenFields = new SeenFields();
        Iterator it = reader.getAttributeNames();
        while (it.hasNext()) {
            Field field;
            String attrAlias = (String)it.next();
            String attrName = this.mapper.realMember(result.getClass(), this.mapper.attributeForAlias(attrAlias));
            Class classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = this.reflectionProvider.fieldDefinedInClass(attrName, result.getClass());
            if (!fieldExistsInClass || Modifier.isTransient((field = this.reflectionProvider.getField(result.getClass(), attrName)).getModifiers()) && !this.shouldUnmarshalTransientFields()) continue;
            SingleValueConverter converter = this.mapper.getConverterFromAttribute(field.getDeclaringClass(), attrName, field.getType());
            type = field.getType();
            if (converter == null) continue;
            value = converter.fromString(reader.getAttribute(attrAlias));
            if (type.isPrimitive()) {
                type = Primitives.box(type);
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                throw new ConversionException("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
            }
            this.reflectionProvider.writeField(result, attrName, value, classDefiningField);
            seenFields.add(classDefiningField, attrName);
        }
        Map implicitCollectionsForCurrentObject = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String originalNodeName = reader.getNodeName();
            String fieldName = this.mapper.realMember(result.getClass(), originalNodeName);
            Mapper.ImplicitCollectionMapping implicitCollectionMapping = this.mapper.getImplicitCollectionDefForFieldName(result.getClass(), fieldName);
            Class<?> classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = implicitCollectionMapping == null && this.reflectionProvider.fieldDefinedInClass(fieldName, result.getClass());
            Class clazz = type = implicitCollectionMapping == null ? this.determineType(reader, fieldExistsInClass, result, fieldName, classDefiningField) : implicitCollectionMapping.getItemType();
            if (fieldExistsInClass) {
                Field field = this.reflectionProvider.getField(classDefiningField != null ? classDefiningField : result.getClass(), fieldName);
                if (Modifier.isTransient(field.getModifiers()) && !this.shouldUnmarshalTransientFields()) {
                    reader.moveUp();
                    continue;
                }
                value = this.unmarshallField(context, result, type, field);
                Class definedType = this.reflectionProvider.getFieldType(result, fieldName, classDefiningField);
                if (!definedType.isPrimitive()) {
                    type = definedType;
                }
            } else {
                Object object = value = type != null ? context.convertAnother(result, type) : null;
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                throw new ConversionException("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
            }
            if (fieldExistsInClass) {
                this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
                seenFields.add(classDefiningField, fieldName);
            } else if (type != null) {
                implicitCollectionsForCurrentObject = this.writeValueToImplicitCollection(context, value, implicitCollectionsForCurrentObject, result, originalNodeName);
            }
            reader.moveUp();
        }
        return result;
    }

    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        return context.convertAnother(result, type, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
    }

    protected boolean shouldUnmarshalTransientFields() {
        return false;
    }

    private Map writeValueToImplicitCollection(UnmarshallingContext context, Object value, Map implicitCollections, Object result, String itemFieldName) {
        Collection collection;
        String fieldName = this.mapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value != null ? value.getClass() : Mapper.Null.class, itemFieldName);
        if (fieldName != null) {
            if (implicitCollections == null) {
                implicitCollections = new HashMap<String, Collection>();
            }
            if ((collection = (Collection)implicitCollections.get(fieldName)) == null) {
                Class fieldType = this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, null));
                if (!Collection.class.isAssignableFrom(fieldType)) {
                    throw new ObjectAccessException("Field " + fieldName + " of " + result.getClass().getName() + " is configured for an implicit Collection, but field is of type " + fieldType.getName());
                }
                if (this.pureJavaReflectionProvider == null) {
                    this.pureJavaReflectionProvider = new PureJavaReflectionProvider();
                }
                collection = (Collection)this.pureJavaReflectionProvider.newInstance(fieldType);
                this.reflectionProvider.writeField(result, fieldName, collection, null);
                implicitCollections.put(fieldName, collection);
            }
        } else {
            throw new ConversionException("Element " + itemFieldName + " of type " + value.getClass().getName() + " is not defined as field in type " + result.getClass().getName());
        }
        collection.add(value);
        return implicitCollections;
    }

    private Class determineWhichClassDefinesField(HierarchicalStreamReader reader) {
        String attributeName = this.mapper.aliasForSystemAttribute("defined-in");
        String definedIn = attributeName == null ? null : reader.getAttribute(attributeName);
        return definedIn == null ? null : this.mapper.realClass(definedIn);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attributeName = this.mapper.aliasForSystemAttribute("resolves-to");
        String readResolveValue = attributeName == null ? null : reader.getAttribute(attributeName);
        Object currentObject = context.currentObject();
        if (currentObject != null) {
            return currentObject;
        }
        if (readResolveValue != null) {
            return this.reflectionProvider.newInstance(this.mapper.realClass(readResolveValue));
        }
        return this.reflectionProvider.newInstance(context.getRequiredType());
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        String classAttribute = HierarchicalStreams.readClassAttribute(reader, this.mapper);
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        if (!validField) {
            Class itemType = this.mapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                return itemType;
            }
            String originalNodeName = reader.getNodeName();
            if (definedInCls == null) {
                for (definedInCls = result.getClass(); definedInCls != null; definedInCls = definedInCls.getSuperclass()) {
                    if (this.mapper.shouldSerializeMember(definedInCls, originalNodeName)) continue;
                    return null;
                }
            }
            return this.mapper.realClass(originalNodeName);
        }
        return this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, definedInCls));
    }

    private Object readResolve() {
        this.serializationMethodInvoker = new SerializationMethodInvoker();
        return this;
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
            this.add("duplicate-field", msg);
        }
    }

    private static class SeenFields {
        private Set seen = new HashSet();

        private SeenFields() {
        }

        public void add(Class definedInCls, String fieldName) {
            String uniqueKey = fieldName;
            if (definedInCls != null) {
                uniqueKey = uniqueKey + " [" + definedInCls.getName() + "]";
            }
            if (this.seen.contains(uniqueKey)) {
                throw new DuplicateFieldException(uniqueKey);
            }
            this.seen.add(uniqueKey);
        }
    }
}

