/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldKey;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.NonExistentFieldException;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.ConcurrentWeakHashMap;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FieldDictionary {
    private transient Map<Class, Entry> cache;
    private final FieldKeySorter sorter;

    public FieldDictionary() {
        this(new ImmutableFieldKeySorter());
    }

    public FieldDictionary(FieldKeySorter sorter) {
        this.sorter = sorter;
        this.init();
    }

    private void init() {
        this.cache = new ConcurrentWeakHashMap<Class, Entry>();
        this.cache.put(Object.class, new Entry(Collections.EMPTY_MAP, Collections.EMPTY_MAP));
    }

    public Iterator serializableFieldsFor(Class cls) {
        return this.fieldsFor(cls);
    }

    public Iterator fieldsFor(Class cls) {
        return this.buildMap(cls, true).values().iterator();
    }

    public Field field(Class cls, String name, Class definedIn) {
        Field field = this.fieldOrNull(cls, name, definedIn);
        if (field == null) {
            throw new NonExistentFieldException("No such field " + cls.getName() + "." + name, name);
        }
        return field;
    }

    public Field fieldOrNull(Class cls, String name, Class definedIn) {
        Map fields = this.buildMap(cls, definedIn != null);
        Field field = (Field)fields.get(definedIn != null ? new FieldKey(name, definedIn, 0) : name);
        return field;
    }

    private Map buildMap(Class type, boolean tupleKeyed) {
        Class cls2 = type;
        if (!this.cache.containsKey(type)) {
            ArrayList<Class> superClasses = new ArrayList<Class>();
            while (!Object.class.equals((Object)cls2)) {
                superClasses.add(0, cls2);
                cls2 = cls2.getSuperclass();
            }
            Map<String, Field> lastKeyedByFieldName = Collections.EMPTY_MAP;
            Map<FieldKey, Field> lastKeyedByFieldKey = Collections.EMPTY_MAP;
            for (Class cls2 : superClasses) {
                if (!this.cache.containsKey(cls2)) {
                    int i;
                    HashMap<String, Field> keyedByFieldName = new HashMap<String, Field>(lastKeyedByFieldName);
                    OrderRetainingMap keyedByFieldKey = new OrderRetainingMap(lastKeyedByFieldKey);
                    Field[] fields = cls2.getDeclaredFields();
                    if (JVM.reverseFieldDefinition()) {
                        i = fields.length >> 1;
                        while (i-- > 0) {
                            int idx = fields.length - i - 1;
                            Field field = fields[i];
                            fields[i] = fields[idx];
                            fields[idx] = field;
                        }
                    }
                    for (i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        FieldKey fieldKey = new FieldKey(field.getName(), field.getDeclaringClass(), i);
                        field.setAccessible(true);
                        Field existent = (Field)keyedByFieldName.get(field.getName());
                        if (existent == null || (existent.getModifiers() & 8) != 0 || existent != null && (field.getModifiers() & 8) == 0) {
                            keyedByFieldName.put(field.getName(), field);
                        }
                        keyedByFieldKey.put(fieldKey, field);
                    }
                    this.cache.put(cls2, new Entry(keyedByFieldName, this.sorter.sort(type, keyedByFieldKey)));
                }
                Entry e = this.cache.get(cls2);
                lastKeyedByFieldName = e.keyedByFieldName;
                lastKeyedByFieldKey = e.keyedByFieldKey;
            }
        }
        Entry e = this.cache.get(type);
        return tupleKeyed ? e.keyedByFieldKey : e.keyedByFieldName;
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    static final class Entry {
        final Map<String, Field> keyedByFieldName;
        final Map<FieldKey, Field> keyedByFieldKey;

        Entry(Map keyedByFieldName, Map keyedByFieldKey) {
            this.keyedByFieldName = keyedByFieldName;
            this.keyedByFieldKey = keyedByFieldKey;
        }
    }
}

