/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.core.util.PrioritizedList;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultConverterLookup
implements ConverterLookup,
ConverterRegistry {
    private final PrioritizedList converters = new PrioritizedList();
    private transient Map typeToConverterMap = new ConcurrentHashMap();
    private static final NullConverter NULL = new NullConverter();

    public DefaultConverterLookup() {
    }

    public DefaultConverterLookup(Mapper mapper) {
    }

    public DefaultConverterLookup(ClassMapper classMapper) {
    }

    public Converter lookupConverterForType(Class type) {
        if (type == null) {
            return NULL;
        }
        Converter cachedConverter = (Converter)this.typeToConverterMap.get(type);
        if (cachedConverter != null) {
            return cachedConverter;
        }
        Iterator iterator = this.converters.iterator();
        while (iterator.hasNext()) {
            Converter converter = (Converter)iterator.next();
            if (!converter.canConvert(type)) continue;
            this.typeToConverterMap.put(type, converter);
            return converter;
        }
        throw new ConversionException("No converter specified for " + type);
    }

    public void registerConverter(Converter converter, int priority) {
        this.converters.add(converter, priority);
        Iterator iter = this.typeToConverterMap.keySet().iterator();
        while (iter.hasNext()) {
            Class type = (Class)iter.next();
            if (!converter.canConvert(type)) continue;
            iter.remove();
        }
    }

    private Object readResolve() {
        this.typeToConverterMap = new ConcurrentHashMap();
        return this;
    }
}

