/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.jvnet.jax_ws_commons.jaxws.ClassPathNodeListGenerator;
import org.jvnet.jax_ws_commons.jaxws.DependencyResolver;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;

abstract class AbstractJaxwsMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="true")
    protected boolean keep;
    @Parameter(defaultValue="false")
    private boolean extension;
    @Parameter(property="project.build.sourceEncoding")
    protected String encoding;
    @Parameter
    private List<String> args;
    @Parameter
    private List<String> vmArgs;
    @Parameter
    private File executable;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> pluginRepos;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor pluginDescriptor;
    private static final Logger logger = Logger.getLogger(AbstractJaxwsMojo.class.getName());
    private static final List<String> METRO_22 = new ArrayList<String>();
    private static final List<String> METRO_221 = new ArrayList<String>();
    private static final List<String> METRO_23 = new ArrayList<String>();

    AbstractJaxwsMojo() {
    }

    protected abstract String getMain();

    protected abstract File getDestDir();

    protected abstract File getSourceDestDir();

    protected void addSourceRoot(String sourceDir) {
        if (!this.project.getCompileSourceRoots().contains(sourceDir)) {
            this.getLog().debug((CharSequence)("adding src root: " + sourceDir));
            this.project.addCompileSourceRoot(sourceDir);
        } else {
            this.getLog().debug((CharSequence)("existing src root: " + sourceDir));
        }
    }

    protected abstract File getDefaultSrcOut();

    protected abstract boolean getXnocompile();

    protected String getExtraClasspath() {
        return null;
    }

    protected boolean isExtensionOn() {
        return this.extension;
    }

    protected List<String> getCommonArgs() throws MojoExecutionException {
        File destDir;
        ArrayList<String> commonArgs = new ArrayList<String>();
        if (!this.isDefaultSrc(this.getSourceDestDir()) || this.keep) {
            commonArgs.add("-keep");
            commonArgs.add("-s");
            commonArgs.add("'" + this.getSourceDestDir().getAbsolutePath() + "'");
            if (!this.getSourceDestDir().mkdirs() && !this.getSourceDestDir().exists()) {
                this.getLog().warn((CharSequence)("Cannot create directory: " + this.getSourceDestDir().getAbsolutePath()));
            }
            this.addSourceRoot(this.getSourceDestDir().getAbsolutePath());
        }
        if (!(destDir = this.getDestDir()).mkdirs() && !destDir.exists()) {
            this.getLog().warn((CharSequence)("Cannot create directory: " + destDir.getAbsolutePath()));
        }
        commonArgs.add("-d");
        commonArgs.add("'" + destDir.getAbsolutePath() + "'");
        if (this.verbose) {
            commonArgs.add("-verbose");
        }
        if (this.isArgSupported("-encoding")) {
            if (this.encoding != null) {
                this.maybeUnsupportedOption("-encoding", this.encoding, commonArgs);
            } else {
                this.getLog().warn((CharSequence)("Using platform encoding (" + System.getProperty("file.encoding") + "), build is platform dependent!"));
            }
        }
        if (this.isExtensionOn()) {
            commonArgs.add("-extension");
        }
        if (this.getXnocompile()) {
            commonArgs.add("-Xnocompile");
        }
        if (this.args != null) {
            for (String arg : this.args) {
                commonArgs.add(arg);
            }
        }
        return commonArgs;
    }

    protected boolean isArgSupported(String arg) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact a = (org.apache.maven.artifact.Artifact)this.pluginDescriptor.getArtifactMap().get("org.glassfish.metro:webservices-tools");
        List<String> supportedArgs = null;
        String v = null;
        try {
            ArtifactVersion av;
            if (a != null) {
                av = a.getSelectedVersion();
                v = av.toString();
                supportedArgs = av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() == 0 ? METRO_22 : (av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() >= 1 ? METRO_221 : METRO_23);
            } else {
                a = (org.apache.maven.artifact.Artifact)this.pluginDescriptor.getArtifactMap().get("com.sun.xml.ws:jaxws-tools");
                av = a.getSelectedVersion();
                v = av.toString();
                supportedArgs = av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() == 6 ? METRO_22 : (av.getMajorVersion() == 2 && av.getMinorVersion() == 2 && av.getIncrementalVersion() == 7 ? METRO_221 : METRO_23);
            }
        }
        catch (OverConstrainedVersionException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        boolean isSupported = supportedArgs.contains(arg);
        if (!isSupported) {
            this.getLog().warn((CharSequence)("'" + arg + "' is not supported by " + a.getArtifactId() + ":" + v));
        }
        return isSupported;
    }

    private boolean isDefaultSrc(File srcout) {
        return srcout.equals(this.getDefaultSrcOut());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exec(List<String> args) throws MojoExecutionException {
        DefaultConsumer sc = new DefaultConsumer();
        try {
            Commandline cmd = new Commandline();
            if (this.executable != null) {
                if (!this.executable.isFile() || !this.executable.canExecute()) throw new MojoExecutionException("Cannot execute: " + this.executable.getAbsolutePath());
                cmd.setExecutable(this.executable.getAbsolutePath());
                if (this.getExtraClasspath() != null) {
                    cmd.createArg().setLine("-cp");
                    cmd.createArg().setValue(this.getExtraClasspath());
                }
            } else {
                cmd.setExecutable(new File(new File(System.getProperty("java.home"), "bin"), this.getJavaExec()).getAbsolutePath());
                if (this.vmArgs != null) {
                    for (String arg : this.vmArgs) {
                        cmd.createArg().setLine(arg);
                    }
                }
                String[] classpath = this.getCP();
                cmd.createArg().setValue("-Xbootclasspath/p:" + classpath[0]);
                cmd.createArg().setValue("-cp");
                cmd.createArg().setValue(classpath[2]);
                cmd.createArg().setLine("org.jvnet.jax_ws_commons.jaxws.Invoker");
                cmd.createArg().setLine(this.getMain());
                String extraCp = this.getExtraClasspath();
                String cp = extraCp != null ? extraCp + File.pathSeparator : "";
                cp = cp + classpath[1];
                try {
                    File pathFile = this.createPathFile(cp);
                    cmd.createArg().setLine("-pathfile " + pathFile.getAbsolutePath());
                }
                catch (IOException ioe) {
                    cmd.createArg().setValue("-cp");
                    cmd.createArg().setValue(cp);
                }
            }
            cmd.setWorkingDirectory(this.project.getBasedir());
            for (String arg : args) {
                cmd.createArg().setLine(arg);
            }
            String fullCommand = cmd.toString();
            if (this.isWindows() && 8191 <= fullCommand.length()) {
                this.getLog().warn((CharSequence)("Length of the command is limitted to 8191 characters but it has " + fullCommand.length() + " characters."));
                this.getLog().warn((CharSequence)fullCommand);
            } else {
                this.getLog().debug((CharSequence)fullCommand);
            }
            if (CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)sc, (StreamConsumer)sc) == 0) return;
            throw new MojoExecutionException("Mojo failed - check output");
        }
        catch (DependencyResolutionException dre) {
            throw new MojoExecutionException(dre.getMessage(), (Exception)((Object)dre));
        }
        catch (CommandLineException t) {
            throw new MojoExecutionException(t.getMessage(), (Exception)((Object)t));
        }
    }

    protected void maybeUnsupportedOption(String option, String value, List<String> args) {
        if (this.executable == null) {
            args.add(option);
            if (value != null) {
                args.add(value);
            }
        } else {
            this.getLog().warn((CharSequence)(option + " may not supported on older JDKs.\n" + "Use <args> to bypass this warning if you really want to use it."));
        }
    }

    protected String[] getExtraDependencies() {
        return new String[0];
    }

    private String[] getCP() throws DependencyResolutionException {
        HashSet<Artifact> endorsedCp = new HashSet<Artifact>();
        HashMap<String, Artifact> cp = new HashMap<String, Artifact>();
        Plugin p = this.pluginDescriptor.getPlugin();
        for (Dependency d : p.getDependencies()) {
            DependencyResult result = DependencyResolver.resolve(d, this.pluginRepos, this.repoSystem, this.repoSession);
            this.sortArtifacts(result, cp, endorsedCp);
        }
        for (String dep : this.getExtraDependencies()) {
            DependencyResult result = DependencyResolver.resolve((org.apache.maven.artifact.Artifact)this.pluginDescriptor.getArtifactMap().get(dep), this.pluginRepos, this.repoSystem, this.repoSession);
            this.sortArtifacts(result, cp, endorsedCp);
        }
        if (!cp.containsKey("com.sun.xml.ws:jaxws-tools") && !cp.containsKey("org.glassfish.metro:webservices-tools")) {
            DependencyResult result = DependencyResolver.resolve((org.apache.maven.artifact.Artifact)this.pluginDescriptor.getArtifactMap().get("com.sun.xml.ws:jaxws-tools"), this.pluginRepos, this.repoSystem, this.repoSession);
            this.sortArtifacts(result, cp, endorsedCp);
        }
        StringBuilder sb = this.getCPasString(cp.values());
        StringBuilder esb = this.getCPasString(endorsedCp);
        String invokerPath = AbstractJaxwsMojo.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm();
        try {
            invokerPath = new URI(invokerPath.substring(5)).getPath();
            sb.append(invokerPath);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        sb.append(File.pathSeparator);
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(System.getProperty("java.home"), "lib/tools.jar");
        }
        sb.append(toolsJar.getAbsolutePath());
        sb.append(File.pathSeparator);
        return new String[]{esb.substring(0, esb.length() - 1), sb.substring(0, sb.length() - 1), invokerPath};
    }

    private String getJavaExec() {
        return this.isWindows() ? "java.exe" : "java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPathFile(String cp) throws IOException {
        File f = File.createTempFile("jax-ws-mvn-plugin-cp", ".txt");
        if (f.exists() && f.isFile() && !f.delete()) {
            this.getLog().warn((CharSequence)("cannot remove obsolete classpath setting file: " + f.getAbsolutePath()));
        }
        Properties p = new Properties();
        p.put("cp", cp.replace(File.separatorChar, '/'));
        this.getLog().debug((CharSequence)("stored classpath: " + cp.replace(File.separatorChar, '/')));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            p.store(fos, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return f;
    }

    private boolean isWindows() {
        return Os.isFamily((String)"windows");
    }

    private StringBuilder getCPasString(Collection<Artifact> artifacts) {
        StringBuilder sb = new StringBuilder();
        for (Artifact a : artifacts) {
            sb.append(a.getFile().getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        return sb;
    }

    private void sortArtifacts(DependencyResult result, Map<String, Artifact> cp, Set<Artifact> endorsedCp) {
        ClassPathNodeListGenerator nlg = new ClassPathNodeListGenerator();
        result.getRoot().accept((DependencyVisitor)nlg);
        for (Artifact a : nlg.getArtifacts(false)) {
            cp.put(a.getGroupId() + ":" + a.getArtifactId(), a);
        }
        nlg.setEndorsed(true);
        endorsedCp.addAll(nlg.getArtifacts(false));
    }

    static {
        METRO_22.add("-encoding");
        METRO_22.add("-clientjar");
        METRO_22.add("-generateJWS");
        METRO_22.add("-implDestDir");
        METRO_22.add("-implServiceName");
        METRO_22.add("-implPortName");
        METRO_221.addAll(METRO_22);
        METRO_221.add("-XdisableAuthenticator");
        METRO_23.addAll(METRO_221);
        METRO_23.add("-x");
    }
}

