/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.model.annotation.value;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jvnet.jaxb.annox.model.annotation.value.XAnnotationValueVisitor;
import org.jvnet.jaxb.annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XDynamicAnnotationValue;
import org.jvnet.jaxb.annox.util.Validate;

public class XArrayClassAnnotationValue<A, I>
extends XDynamicAnnotationValue<Class<A>> {
    private final XClassByNameAnnotationValue<I> itemClassByNameAnnotationValue;
    private final int dimension;
    private final String arrayClassName;

    public XArrayClassAnnotationValue(XClassByNameAnnotationValue<I> itemClassByNameAnnotationValue, int dimension) {
        this.itemClassByNameAnnotationValue = Validate.notNull(itemClassByNameAnnotationValue);
        Validate.isTrue(dimension > 0);
        this.dimension = dimension;
        String arrayClassName = itemClassByNameAnnotationValue.getClassName();
        for (int index = 0; index < dimension; ++index) {
            arrayClassName = arrayClassName + "[]";
        }
        this.arrayClassName = arrayClassName;
    }

    public XClassByNameAnnotationValue<I> getItemClassByNameAnnotationValue() {
        return this.itemClassByNameAnnotationValue;
    }

    public String getItemClassName() {
        return this.itemClassByNameAnnotationValue.getClassName();
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    protected Object getInternalValue() {
        return this.arrayClassName;
    }

    @Override
    public <P> P accept(XAnnotationValueVisitor<P> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Class<A> getValue() {
        Object componentType = this.itemClassByNameAnnotationValue.getValue();
        int[] dimensions = new int[this.dimension];
        Arrays.fill(dimensions, 0);
        Object array = Array.newInstance(componentType, dimensions);
        Class<?> arrayClass = array.getClass();
        return arrayClass;
    }
}

