/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.parser;

import com.github.javaparser.ParseException;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jvnet.jaxb.annox.annotation.AnnotationClassNotFoundException;
import org.jvnet.jaxb.annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.jaxb.annox.javaparser.AnnotationExprParser;
import org.jvnet.jaxb.annox.javaparser.ast.visitor.AbstractGenericExpressionVisitor;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.annox.model.annotation.field.XAnnotationField;
import org.jvnet.jaxb.annox.parser.XGenericFieldParser;
import org.jvnet.jaxb.annox.parser.exception.AnnotationElementParseException;
import org.jvnet.jaxb.annox.parser.exception.AnnotationExpressionParseException;
import org.jvnet.jaxb.annox.parser.exception.AnnotationStringParseException;
import org.jvnet.jaxb.annox.util.ClassUtils;
import org.jvnet.jaxb.annox.util.StringUtils;
import org.jvnet.jaxb.annox.util.Validate;
import org.w3c.dom.Element;

public class XAnnotationParser {
    public static final XAnnotationParser INSTANCE = new XAnnotationParser();
    private final ClassLoader classLoader;

    public XAnnotationParser() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public XAnnotationParser(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public XAnnotation<?> parse(Annotation annotation) {
        Objects.requireNonNull(annotation, "Annotation must not be null.");
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        XAnnotationField<?>[] fields = this.parseFields(annotation, annotationClass);
        XAnnotation<? extends Annotation> xannotation = new XAnnotation<Annotation>(annotationClass, fields);
        return xannotation;
    }

    public XAnnotation<?>[] parse(Annotation[] annotations) {
        Validate.noNullElements(annotations, "Annotations must not contain nulls.");
        XAnnotation[] xannotations = new XAnnotation[annotations.length];
        for (int index = 0; index < annotations.length; ++index) {
            Annotation annotation = annotations[index];
            xannotations[index] = this.parse(annotation);
        }
        return xannotations;
    }

    public XAnnotation<?> parse(Element annotationElement) throws AnnotationElementParseException {
        String className;
        Objects.requireNonNull(annotationElement, "Annotation element must not be null.");
        String name = annotationElement.getLocalName();
        String classAttribute = annotationElement.getAttributeNS("http://annox.dev.java.net", "class");
        if (!StringUtils.isEmpty(classAttribute)) {
            className = classAttribute;
        } else {
            String namespaceURI = annotationElement.getNamespaceURI();
            if (namespaceURI != null && namespaceURI.startsWith("http://annox.dev.java.net/")) {
                String containerPrefix = namespaceURI.substring("http://annox.dev.java.net/".length());
                className = containerPrefix + "." + name.replace('.', '$');
            } else {
                className = name;
            }
        }
        try {
            Class<?> draftClass = this.classLoader.loadClass(className);
            if (!Annotation.class.isAssignableFrom(draftClass)) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)new IllegalArgumentException(MessageFormat.format("The class [{0}] is not an annotation class.", draftClass.getName())));
            }
            Class<?> annotationClass = draftClass;
            XAnnotationField<?>[] fields = this.parseFields(annotationElement, annotationClass);
            XAnnotation xannotation = new XAnnotation(annotationClass, fields);
            return xannotation;
        }
        catch (ClassNotFoundException cnfex) {
            throw new AnnotationElementParseException(annotationElement, (Throwable)new AnnotationClassNotFoundException(className, cnfex));
        }
        catch (AnnotationElementParseException cnfex) {
            throw new AnnotationElementParseException(annotationElement, (Throwable)new AnnotationClassNotFoundException(className, cnfex));
        }
    }

    public XAnnotation<?>[] parse(Element[] annotationElements) throws AnnotationElementParseException {
        Validate.noNullElements(annotationElements, "Annotation elements must not contain null.");
        XAnnotation[] xannotations = new XAnnotation[annotationElements.length];
        for (int index = 0; index < annotationElements.length; ++index) {
            Element annotationElement = annotationElements[index];
            try {
                xannotations[index] = this.parse(annotationElement);
                continue;
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }
        return xannotations;
    }

    public XAnnotation<?> parse(String annotationString) throws AnnotationStringParseException, AnnotationExpressionParseException {
        AnnotationExpr expression = this.parseAnnotationExpr(annotationString);
        return this.parse(expression);
    }

    public XAnnotation<?>[] parse(String[] annotationStrings) throws AnnotationStringParseException, AnnotationExpressionParseException {
        Validate.noNullElements(annotationStrings);
        ArrayList<AnnotationExpr> allAnnotationExprs = new ArrayList<AnnotationExpr>(annotationStrings.length);
        for (String annotationString : annotationStrings) {
            allAnnotationExprs.addAll(this.parseAnnotationExprs(annotationString));
        }
        AnnotationExpr[] annotationExprs = new AnnotationExpr[allAnnotationExprs.size()];
        allAnnotationExprs.toArray(annotationExprs);
        return this.parse(annotationExprs);
    }

    private AnnotationExpr parseAnnotationExpr(String annotationString) throws AnnotationStringParseException {
        List<AnnotationExpr> annotationExprs = this.parseAnnotationExprs(annotationString);
        if (annotationExprs.isEmpty()) {
            throw new AnnotationStringParseException(MessageFormat.format("Could not parse the annotation [{0}], this expression apparently contains no annotations.", annotationString), annotationString);
        }
        if (annotationExprs.size() > 1) {
            throw new AnnotationStringParseException(MessageFormat.format("Could not parse the annotation [{0}], this expression apparently more than one annotation.", annotationString), annotationString);
        }
        return annotationExprs.get(0);
    }

    private List<AnnotationExpr> parseAnnotationExprs(String annotationString) throws AnnotationStringParseException {
        AnnotationExprParser parser = new AnnotationExprParser();
        try {
            List<AnnotationExpr> annotations = parser.parse(annotationString);
            return annotations;
        }
        catch (ParseException pex) {
            throw new AnnotationStringParseException(MessageFormat.format("Could not parse the annotation [{0}].", annotationString), annotationString, pex);
        }
    }

    public XAnnotation<?> parse(AnnotationExpr annotationElement) throws AnnotationExpressionParseException {
        Objects.requireNonNull(annotationElement, "Annotation expression must not be null.");
        String className = annotationElement.getName().toString();
        try {
            Class<?> draftClass = ClassUtils.getClass(this.classLoader, className);
            if (!Annotation.class.isAssignableFrom(draftClass)) {
                throw new AnnotationExpressionParseException((Node)annotationElement, (Throwable)new IllegalArgumentException(MessageFormat.format("The class [{0}] is not an annotation class.", draftClass.getName())));
            }
            Class<?> annotationClass = draftClass;
            XAnnotationField<?>[] fields = this.parseFields(annotationElement, annotationClass);
            XAnnotation xannotation = new XAnnotation(annotationClass, fields);
            return xannotation;
        }
        catch (ClassNotFoundException cnfex) {
            throw new AnnotationExpressionParseException((Node)annotationElement, (Throwable)new AnnotationClassNotFoundException(className, cnfex));
        }
    }

    public XAnnotation<?>[] parse(AnnotationExpr[] annotationElements) throws AnnotationExpressionParseException {
        Validate.noNullElements(annotationElements, "Annotation elements must not contain null.");
        XAnnotation[] xannotations = new XAnnotation[annotationElements.length];
        for (int index = 0; index < annotationElements.length; ++index) {
            AnnotationExpr annotationElement = annotationElements[index];
            try {
                xannotations[index] = this.parse(annotationElement);
                continue;
            }
            catch (AnnotationExpressionParseException aepex) {
                throw new AnnotationExpressionParseException((Node)annotationElement, (Throwable)aepex);
            }
        }
        return xannotations;
    }

    public XAnnotationField<?>[] parseFields(Element annotationElement, Class<? extends Annotation> annotationClass) throws AnnotationElementParseException {
        Method[] methods = annotationClass.getMethods();
        HashMap fieldsMap = new HashMap();
        for (Method method : methods) {
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            Class<?> type = method.getReturnType();
            fieldsMap.put(name, type);
        }
        ArrayList fields = new ArrayList(fieldsMap.size());
        for (Map.Entry entry : fieldsMap.entrySet()) {
            String name = (String)entry.getKey();
            Class type = (Class)entry.getValue();
            try {
                XAnnotationField<?> field = this.parseField(annotationElement, name, type);
                if (field == null) continue;
                fields.add(field);
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }
        return fields.toArray(new XAnnotationField[fields.size()]);
    }

    public XAnnotationField<?>[] parseFields(Annotation annotation, Class<? extends Annotation> annotationClass) {
        Method[] methods = annotationClass.getMethods();
        ArrayList fields = new ArrayList(methods.length);
        for (Method method : methods) {
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            Class<?> type = method.getReturnType();
            try {
                fields.add(this.parseField(annotation, name, type));
            }
            catch (NoSuchAnnotationFieldException nsafex) {
                throw new AssertionError((Object)nsafex);
            }
        }
        return fields.toArray(new XAnnotationField[fields.size()]);
    }

    public XAnnotationField<?>[] parseFields(AnnotationExpr annotationExpr, Class<? extends Annotation> annotationClass) throws AnnotationExpressionParseException {
        Class type;
        List pairs = (List)annotationExpr.accept((GenericVisitor)new AbstractGenericExpressionVisitor<List<MemberValuePair>, Void>(){

            @Override
            public List<MemberValuePair> visitDefault(Node n, Void arg) {
                throw new IllegalArgumentException();
            }

            @Override
            public List<MemberValuePair> visit(NormalAnnotationExpr n, Void arg) {
                return n.getPairs();
            }

            @Override
            public List<MemberValuePair> visit(MarkerAnnotationExpr n, Void arg) {
                return Collections.emptyList();
            }

            @Override
            public List<MemberValuePair> visit(SingleMemberAnnotationExpr n, Void arg) {
                return Collections.singletonList(new MemberValuePair("value", n.getMemberValue()));
            }
        }, null);
        Method[] methods = annotationClass.getMethods();
        HashMap<String, Class> fieldsMap = new HashMap<String, Class>();
        for (Method method : methods) {
            if (Annotation.class.equals(method.getDeclaringClass())) continue;
            String name = method.getName();
            type = method.getReturnType();
            fieldsMap.put(name, type);
        }
        ArrayList fields = new ArrayList(fieldsMap.size());
        for (MemberValuePair memberValuePair : pairs) {
            String name = memberValuePair.getNameAsString();
            Expression value = memberValuePair.getValue();
            type = (Class)fieldsMap.get(name);
            if (type == null) continue;
            fields.add(this.parseField(value, name, type));
        }
        return fields.toArray(new XAnnotationField[fields.size()]);
    }

    public XAnnotationField<?> parseField(Expression annotationExpression, String name, Class<?> type) throws AnnotationExpressionParseException {
        XAnnotationField field = XGenericFieldParser.GENERIC.parse(annotationExpression, name, type);
        return field;
    }

    public XAnnotationField<?> parseField(Element annotationElement, String name, Class<?> type) throws AnnotationElementParseException {
        XAnnotationField field = XGenericFieldParser.GENERIC.parse(annotationElement, name, type);
        return field;
    }

    public XAnnotationField<?> parseField(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
        XAnnotationField field = XGenericFieldParser.GENERIC.parse(annotation, name, type);
        return field;
    }
}

