/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.util;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jvnet.jaxb.annox.util.StringUtils;
import org.jvnet.jaxb.annox.util.Validate;

public class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final Map<String, String> abbreviationMap;
    private static Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    private static Map<String, Class<?>> namePrimitiveMap;
    public static final String ARRAY_SUFFIX = "[]";
    public static final Class<?>[] EMPTY_CLASS_ARRAY;

    public static Class primitiveToWrapper(Class cls) {
        Validate.notNull(cls);
        if (cls.isPrimitive()) {
            return primitiveWrapperMap.get(cls);
        }
        return cls;
    }

    public static Class wrapperToPrimitive(Class cls) {
        Validate.notNull(cls);
        Class<?> primitiveClass = wrapperPrimitiveMap.get(cls);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        return cls;
    }

    public static Class wrapperArrayToPrimitiveArray(Class cls) {
        Validate.notNull(cls);
        Validate.isTrue(cls.isArray());
        Class<?> componentType = cls.getComponentType();
        Class primitiveComponentType = ClassUtils.wrapperToPrimitive(componentType);
        if (primitiveComponentType == componentType) {
            return cls;
        }
        Object array = Array.newInstance(primitiveComponentType, 0);
        return array.getClass();
    }

    public static Class nameToPrimitive(String name) {
        if (name == null) {
            return null;
        }
        return namePrimitiveMap.get(name);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> forName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        if (className.endsWith(ARRAY_SUFFIX)) {
            String componentClassName = className.substring(0, className.length() - ARRAY_SUFFIX.length());
            return ClassUtils.getArrayClass(ClassUtils.forName(componentClassName, initialize, loader));
        }
        Class primitiveClass = ClassUtils.nameToPrimitive(className);
        if (primitiveClass != null) {
            return primitiveClass;
        }
        return Class.forName(className, initialize, loader);
    }

    public static Class<?> getArrayClass(Class<?> componentClass) {
        Object componentArray = Array.newInstance(componentClass, 0);
        return componentArray.getClass();
    }

    public static Class<?>[] forNames(String names) throws ClassNotFoundException {
        return ClassUtils.forNames(names, true, null);
    }

    public static Class<?>[] forNames(String names, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        if (names == null) {
            return null;
        }
        String n = names.trim();
        if ("".equals(n)) {
            return EMPTY_CLASS_ARRAY;
        }
        String[] classNames = n.split(",");
        Class[] classes = new Class[classNames.length];
        for (int index = 0; index < classNames.length; ++index) {
            classes[index] = ClassUtils.forName(classNames[index].trim(), initialize, loader);
        }
        return classes;
    }

    public static Class<?> getClass(String className) throws ClassNotFoundException {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextCL == null ? ClassUtils.class.getClassLoader() : contextCL;
        return ClassUtils.getClass(loader, className);
    }

    public static Class<?> getClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        try {
            Class<?> clazz = namePrimitiveMap.get(className);
            return clazz != null ? clazz : Class.forName(ClassUtils.toCanonicalName(className), true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                try {
                    return ClassUtils.getClass(classLoader, className.substring(0, lastDotIndex) + "$" + className.substring(lastDotIndex + 1));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private static String toCanonicalName(String className) {
        String canonicalName = StringUtils.deleteWhitespace(className);
        Objects.requireNonNull(canonicalName, "className");
        if (canonicalName.endsWith(ARRAY_SUFFIX)) {
            StringBuilder classNameBuffer = new StringBuilder();
            while (canonicalName.endsWith(ARRAY_SUFFIX)) {
                canonicalName = canonicalName.substring(0, canonicalName.length() - 2);
                classNameBuffer.append("[");
            }
            String abbreviation = abbreviationMap.get(canonicalName);
            if (abbreviation != null) {
                classNameBuffer.append(abbreviation);
            } else {
                classNameBuffer.append("L").append(canonicalName).append(";");
            }
            canonicalName = classNameBuffer.toString();
        }
        return canonicalName;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "I");
        map.put("boolean", "Z");
        map.put("float", "F");
        map.put("long", "J");
        map.put("short", "S");
        map.put("byte", "B");
        map.put("double", "D");
        map.put("char", "C");
        abbreviationMap = Collections.unmodifiableMap(map);
        primitiveWrapperMap = new HashMap();
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        wrapperPrimitiveMap = new HashMap();
        wrapperPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperPrimitiveMap.put(Float.class, Float.TYPE);
        namePrimitiveMap = new HashMap(8);
        namePrimitiveMap.put("boolean", Boolean.TYPE);
        namePrimitiveMap.put("byte", Byte.TYPE);
        namePrimitiveMap.put("char", Character.TYPE);
        namePrimitiveMap.put("short", Short.TYPE);
        namePrimitiveMap.put("int", Integer.TYPE);
        namePrimitiveMap.put("long", Long.TYPE);
        namePrimitiveMap.put("double", Double.TYPE);
        namePrimitiveMap.put("float", Float.TYPE);
        EMPTY_CLASS_ARRAY = new Class[0];
    }
}

