/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.reader.resourced;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.annox.model.XClass;
import org.jvnet.jaxb.annox.model.XConstructor;
import org.jvnet.jaxb.annox.model.XField;
import org.jvnet.jaxb.annox.model.XMethod;
import org.jvnet.jaxb.annox.model.XPackage;
import org.jvnet.jaxb.annox.model.XParameter;
import org.jvnet.jaxb.annox.parser.XAnnotationParser;
import org.jvnet.jaxb.annox.parser.exception.AnnotationElementParseException;
import org.jvnet.jaxb.annox.reader.resourced.NClass;
import org.jvnet.jaxb.annox.reader.resourced.NConstructor;
import org.jvnet.jaxb.annox.reader.resourced.NField;
import org.jvnet.jaxb.annox.reader.resourced.NMethod;
import org.jvnet.jaxb.annox.reader.resourced.NPackage;
import org.jvnet.jaxb.annox.reader.resourced.NParameter;
import org.jvnet.jaxb.annox.util.ClassUtils;
import org.jvnet.jaxb.annox.util.ReflectionUtils;
import org.w3c.dom.Element;

public class NXConverter {
    private final XAnnotationParser xannotationParser;
    private final ClassLoader classLoader;

    public NXConverter() {
        this(XAnnotationParser.INSTANCE, Thread.currentThread().getContextClassLoader());
    }

    public NXConverter(XAnnotationParser xannotationParser, ClassLoader classLoader) {
        ClassLoader contextClassLoader;
        this.xannotationParser = xannotationParser;
        this.classLoader = classLoader != null ? classLoader : ((contextClassLoader = Thread.currentThread().getContextClassLoader()) != null ? contextClassLoader : NXConverter.class.getClassLoader());
    }

    protected XAnnotationParser getXAnnotationParser() {
        return this.xannotationParser;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public XPackage convertNPackage(Package thePackage, NPackage npackage) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, AnnotationElementParseException {
        LinkedList<XClass> classes = new LinkedList<XClass>();
        LinkedList<Element> annotationElements = null;
        if (npackage.content != null) {
            for (Object item : npackage.content) {
                if (item instanceof Element) {
                    if (annotationElements == null) {
                        annotationElements = new LinkedList<Element>();
                    }
                    annotationElements.add((Element)item);
                    continue;
                }
                if (!(item instanceof NClass)) continue;
                NClass nclass = (NClass)item;
                Class<?> theClass = this.getClass(thePackage, nclass.name);
                classes.add(this.convertNClass(theClass, nclass));
            }
        }
        XAnnotation<?>[] xannotations = this.parseAnnotations(annotationElements);
        XClass[] xclasses = classes.toArray(new XClass[classes.size()]);
        return new XPackage(thePackage, xannotations, xclasses);
    }

    public XClass convertNClass(Class<?> theClass, NClass nclass) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, AnnotationElementParseException {
        LinkedList<Element> content = null;
        LinkedList<XField> xfields = new LinkedList<XField>();
        LinkedList<XConstructor> xconstructors = new LinkedList<XConstructor>();
        LinkedList<XMethod> xmethods = new LinkedList<XMethod>();
        if (nclass.content != null) {
            for (Object item : nclass.content) {
                if (item instanceof Element) {
                    if (content == null) {
                        content = new LinkedList<Element>();
                    }
                    content.add((Element)item);
                    continue;
                }
                if (item instanceof NField) {
                    xfields.add(this.convertNField(theClass, (NField)item));
                    continue;
                }
                if (item instanceof NConstructor) {
                    xconstructors.add(this.convertNConstructor(theClass, (NConstructor)item));
                    continue;
                }
                if (!(item instanceof NMethod)) continue;
                xmethods.add(this.convertNMethod(theClass, (NMethod)item));
            }
        }
        XAnnotation<?>[] annotations = this.parseAnnotations(content);
        XField[] fields = xfields.toArray(new XField[xfields.size()]);
        XConstructor[] constructors = xconstructors.toArray(new XConstructor[xconstructors.size()]);
        XMethod[] methods = xmethods.toArray(new XMethod[xmethods.size()]);
        return new XClass(theClass, annotations, fields, constructors, methods);
    }

    public XField convertNField(Class<?> theClass, NField nfield) throws NoSuchFieldException, AnnotationElementParseException {
        Field field = this.getField(theClass, nfield.name);
        XAnnotation<?>[] annotations = this.parseAnnotations(nfield.content);
        return new XField(field, annotations);
    }

    public XConstructor convertNConstructor(Class<?> theClass, NConstructor nconstructor) throws ClassNotFoundException, NoSuchMethodException, AnnotationElementParseException {
        Constructor<?> theConstructor = this.getConstructor(theClass, this.parseArguments(nconstructor.arguments));
        LinkedList<Element> elements = null;
        LinkedList<NParameter> nparameters = null;
        if (nconstructor.content != null) {
            for (Object item : nconstructor.content) {
                if (item instanceof Element) {
                    if (elements == null) {
                        elements = new LinkedList<Element>();
                    }
                    elements.add((Element)item);
                    continue;
                }
                if (!(item instanceof NParameter)) continue;
                if (nparameters == null) {
                    nparameters = new LinkedList<NParameter>();
                }
                nparameters.add((NParameter)item);
            }
        }
        XAnnotation<?>[] xannotations = this.parseAnnotations(elements);
        XParameter[] xparameters = this.convertNParameters(theConstructor.getParameterTypes(), nparameters);
        return new XConstructor(theConstructor, xannotations, xparameters);
    }

    public XMethod convertNMethod(Class<?> theClass, NMethod nmethod) throws ClassNotFoundException, NoSuchMethodException, AnnotationElementParseException {
        Method method = this.getMethod(theClass, nmethod.name, this.parseArguments(nmethod.arguments));
        LinkedList<Element> elements = null;
        LinkedList<NParameter> nparameters = null;
        if (nmethod.content != null) {
            for (Object item : nmethod.content) {
                if (item instanceof Element) {
                    if (elements == null) {
                        elements = new LinkedList<Element>();
                    }
                    elements.add((Element)item);
                    continue;
                }
                if (!(item instanceof NParameter)) continue;
                if (nparameters == null) {
                    nparameters = new LinkedList<NParameter>();
                }
                nparameters.add((NParameter)item);
            }
        }
        XAnnotation<?>[] xannotations = this.parseAnnotations(elements);
        XParameter[] xparameters = this.convertNParameters(method.getParameterTypes(), nparameters);
        return new XMethod(method, xannotations, xparameters);
    }

    public XParameter[] convertNParameters(Class<?>[] parameterTypes, List<NParameter> nparameters) throws AnnotationElementParseException {
        NParameter[] nparametersArray = new NParameter[parameterTypes.length];
        if (nparameters != null) {
            Iterator<NParameter> iterator = nparameters.iterator();
            while (iterator.hasNext()) {
                NParameter nparameter;
                nparametersArray[nparameter.index] = nparameter = iterator.next();
            }
        }
        XParameter[] xparameters = new XParameter[parameterTypes.length];
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> parameterType = parameterTypes[index];
            NParameter nparameter = nparametersArray[index];
            xparameters[index] = this.convertNParameter(parameterType, nparameter);
        }
        return xparameters;
    }

    public XParameter convertNParameter(Class<?> parameterType, NParameter nparameter) throws AnnotationElementParseException {
        Validate.notNull(parameterType);
        XAnnotation<?>[] annotations = nparameter == null ? XAnnotation.EMPTY_ARRAY : this.parseAnnotations(nparameter.content);
        return new XParameter(parameterType, annotations);
    }

    protected Class<?> getClass(Package thePackage, String name) throws ClassNotFoundException {
        String className = thePackage.getName() + "." + name;
        return ClassUtils.forName(className, true, this.getClassLoader());
    }

    protected Field getField(Class<?> theClass, String name) throws NoSuchFieldException {
        return ReflectionUtils.getField(theClass, name);
    }

    protected Constructor<?> getConstructor(Class<?> theClass, Class<?>[] arguments) throws NoSuchMethodException {
        return ReflectionUtils.getConstructor(theClass, arguments);
    }

    protected Method getMethod(Class<?> theClass, String name, Class<?>[] arguments) throws NoSuchMethodException {
        return ReflectionUtils.getMethod(theClass, name, arguments);
    }

    protected XAnnotation<?>[] parseAnnotations(List<Element> elements) throws AnnotationElementParseException {
        if (elements == null || elements.isEmpty()) {
            return XAnnotation.EMPTY_ARRAY;
        }
        Element[] annotationElements = elements.toArray(new Element[elements.size()]);
        return this.getXAnnotationParser().parse(annotationElements);
    }

    protected Class<?>[] parseArguments(String arguments) throws ClassNotFoundException {
        return ClassUtils.forNames(arguments, true, this.getClassLoader());
    }
}

