/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.reader.resourced;

import jakarta.xml.bind.JAXBContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb.annox.model.XClass;
import org.jvnet.jaxb.annox.model.XConstructor;
import org.jvnet.jaxb.annox.model.XField;
import org.jvnet.jaxb.annox.model.XMethod;
import org.jvnet.jaxb.annox.model.XPackage;
import org.jvnet.jaxb.annox.parser.XAnnotationParser;
import org.jvnet.jaxb.annox.parser.exception.AnnotationElementParseException;
import org.jvnet.jaxb.annox.reader.XReader;
import org.jvnet.jaxb.annox.reader.resourced.NClass;
import org.jvnet.jaxb.annox.reader.resourced.NPackage;
import org.jvnet.jaxb.annox.reader.resourced.NParser;
import org.jvnet.jaxb.annox.reader.resourced.NXConverter;
import org.jvnet.jaxb.annox.reflect.AnnotatedElementException;

public class ResourcedXReader
implements XReader {
    private final NParser nparser;
    private final NXConverter nxconverter;
    private final ClassLoader classLoader;
    private Map<Package, XPackage> packages = new WeakHashMap<Package, XPackage>();
    private Map<Class<?>, XClass> classes = new WeakHashMap();
    private Map<Class<?>, XClass> packageClasses = new WeakHashMap();
    private Map<Field, XField> fields = new WeakHashMap<Field, XField>();
    private Map<Constructor<?>, XConstructor> constructors = new WeakHashMap();
    private Map<Method, XMethod> methods = new WeakHashMap<Method, XMethod>();

    public ResourcedXReader() {
        this.nparser = new NParser();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.classLoader = contextClassLoader != null ? contextClassLoader : NXConverter.class.getClassLoader();
        this.nxconverter = new NXConverter(XAnnotationParser.INSTANCE, this.classLoader);
    }

    public ResourcedXReader(ClassLoader classLoader) {
        Validate.notNull((Object)classLoader);
        this.nparser = new NParser();
        this.classLoader = classLoader;
        this.nxconverter = new NXConverter(new XAnnotationParser(this.classLoader), this.classLoader);
    }

    public ResourcedXReader(ClassLoader classLoader, JAXBContext context, XAnnotationParser xannotationParser) {
        Validate.notNull((Object)classLoader);
        Validate.notNull((Object)context);
        Validate.notNull((Object)xannotationParser);
        this.classLoader = classLoader;
        this.nparser = new NParser(context);
        this.nxconverter = new NXConverter(xannotationParser, classLoader);
    }

    public ResourcedXReader(ClassLoader classLoader, NParser nparser, NXConverter nxconverter) {
        Validate.notNull((Object)classLoader);
        Validate.notNull((Object)nparser);
        Validate.notNull((Object)nxconverter);
        this.classLoader = classLoader;
        this.nparser = nparser;
        this.nxconverter = nxconverter;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected NParser getNParser() {
        return this.nparser;
    }

    protected NXConverter getNXConverter() {
        return this.nxconverter;
    }

    @Override
    public XPackage getXPackage(Package thePackage) throws AnnotatedElementException {
        XPackage one = this.packages.get(thePackage);
        if (one != null) {
            if (one == XPackage.VOID) {
                return null;
            }
            return one;
        }
        String resourceName = this.getResourceName(thePackage);
        InputStream is = this.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            this.packages.put(thePackage, XPackage.VOID);
            return null;
        }
        try {
            return this.loadXPackage(thePackage, is);
        }
        catch (IOException ex) {
            throw new AnnotatedElementException(thePackage, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new AnnotatedElementException(thePackage, (Throwable)ex);
        }
        catch (NoSuchFieldException ex) {
            throw new AnnotatedElementException(thePackage, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new AnnotatedElementException(thePackage, (Throwable)ex);
        }
        catch (AnnotationElementParseException ex) {
            throw new AnnotatedElementException(thePackage, (Throwable)ex);
        }
    }

    @Override
    public XClass getXClass(Class<?> theClass) throws AnnotatedElementException {
        Validate.notNull(theClass);
        XClass one = this.classes.get(theClass);
        if (one != null && one != XClass.VOID) {
            return one;
        }
        XClass two = this.packageClasses.get(theClass);
        if (two != null) {
            if (two == XClass.VOID) {
                return null;
            }
            return two;
        }
        String resourceName = this.getResourceName(theClass);
        InputStream is = this.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            this.classes.put(theClass, XClass.VOID);
            Package thePackage = theClass.getPackage();
            XPackage xpackage = this.getXPackage(thePackage);
            if (xpackage == null) {
                this.packageClasses.put(theClass, XClass.VOID);
                return null;
            }
            for (XClass xclass : xpackage.getClasses()) {
                if (!xclass.getTargetClass().equals(theClass)) continue;
                return xclass;
            }
            this.packageClasses.put(theClass, XClass.VOID);
            return null;
        }
        try {
            return this.loadXClass(theClass, is);
        }
        catch (IOException ex) {
            throw new AnnotatedElementException(theClass, (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new AnnotatedElementException(theClass, (Throwable)ex);
        }
        catch (NoSuchFieldException ex) {
            throw new AnnotatedElementException(theClass, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new AnnotatedElementException(theClass, (Throwable)ex);
        }
        catch (AnnotationElementParseException ex) {
            throw new AnnotatedElementException(theClass, (Throwable)ex);
        }
    }

    @Override
    public XField getXField(Field theField) throws AnnotatedElementException {
        Validate.notNull((Object)theField);
        return this.getXField(theField.getDeclaringClass(), theField);
    }

    @Override
    public XField getXField(Class<?> theClass, Field theField) throws AnnotatedElementException {
        Validate.notNull(theClass);
        Validate.notNull((Object)theField);
        XClass xclass = this.getXClass(theClass);
        if (xclass == null) {
            return null;
        }
        for (XField field : xclass.getFields()) {
            if (!theField.equals(field.getField())) continue;
            return field;
        }
        return null;
    }

    @Override
    public XConstructor getXConstructor(Constructor<?> theConstructor) throws AnnotatedElementException {
        Validate.notNull(theConstructor);
        return this.getXConstructor(theConstructor.getDeclaringClass(), theConstructor);
    }

    @Override
    public XConstructor getXConstructor(Class<?> theClass, Constructor<?> theConstructor) throws AnnotatedElementException {
        Validate.notNull(theClass);
        Validate.notNull(theConstructor);
        XClass xclass = this.getXClass(theClass);
        if (xclass == null) {
            return null;
        }
        for (XConstructor constructor : xclass.getConstructors()) {
            if (!theConstructor.equals(constructor.getConstructor())) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public XMethod getXMethod(Method theMethod) throws AnnotatedElementException {
        Validate.notNull((Object)theMethod);
        return this.getXMethod(theMethod.getDeclaringClass(), theMethod);
    }

    @Override
    public XMethod getXMethod(Class<?> theClass, Method theMethod) throws AnnotatedElementException {
        Validate.notNull(theClass);
        Validate.notNull((Object)theMethod);
        XClass xclass = this.getXClass(theClass);
        if (xclass == null) {
            return null;
        }
        for (XMethod method : xclass.getMethods()) {
            if (!theMethod.equals(method.getMethod())) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XPackage loadXPackage(Package thePackage, InputStream is) throws IOException, ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, AnnotationElementParseException {
        try {
            XPackage xpackage = this.parseXPackage(thePackage, is);
            this.packages.put(thePackage, xpackage);
            for (XClass xclass : xpackage.getClasses()) {
                this.packageClasses.put(xclass.getTargetClass(), xclass);
            }
            XPackage xPackage = xpackage;
            return xPackage;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XClass loadXClass(Class<?> theClass, InputStream is) throws IOException, ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, AnnotationElementParseException {
        try {
            XClass xclass = this.parseXClass(theClass, is);
            this.classes.put(theClass, xclass);
            XClass xClass = xclass;
            return xClass;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected XPackage parseXPackage(Package thePackage, InputStream is) throws IOException, ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, AnnotationElementParseException {
        NPackage npackage = this.getNParser().parseNPackage(is);
        XPackage xpackage = this.getNXConverter().convertNPackage(thePackage, npackage);
        return xpackage;
    }

    protected XClass parseXClass(Class<?> theClass, InputStream is) throws IOException, ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, AnnotationElementParseException {
        NClass nclass = this.getNParser().parseNClass(is);
        XClass xclass = this.getNXConverter().convertNClass(theClass, nclass);
        return xclass;
    }

    protected String getResourceName(Package thePackage) {
        String resourceName = (String)(thePackage == null ? "" : thePackage.getName().replace('.', '/') + "/") + "package-info.ann.xml";
        return resourceName;
    }

    protected String getResourceName(Class<?> theClass) {
        String resourceName = theClass.getName().replace('.', '/') + ".ann.xml";
        return resourceName;
    }
}

