/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.model;

import org.jvnet.jaxb.annox.model.XAnnotatedElement;
import org.jvnet.jaxb.annox.model.XAnnotation;
import org.jvnet.jaxb.annox.model.XConstructor;
import org.jvnet.jaxb.annox.model.XField;
import org.jvnet.jaxb.annox.model.XMember;
import org.jvnet.jaxb.annox.model.XMethod;
import org.jvnet.jaxb.annox.util.Validate;

public class XClass
extends XAnnotatedElement<Class<?>> {
    public static final XClass[] EMPTY_ARRAY = new XClass[0];
    public static final XClass VOID = new XClass(Void.class, XAnnotation.EMPTY_ARRAY, XField.EMPTY_ARRAY, XConstructor.EMPTY_ARRAY, XMethod.EMPTY_ARRAY);
    private final Class<?> targetClass;
    private final XMember<?>[] members;
    private final XConstructor[] constructors;
    private final XField[] fields;
    private final XMethod[] methods;

    public XClass(Class<?> targetClass, XAnnotation<?>[] xannotations, XField[] xfields, XConstructor[] xconstructors, XMethod[] xmethods) {
        super(targetClass, xannotations);
        Validate.noNullElements(xconstructors, "Constructors must not contain null elements.");
        Validate.noNullElements(xfields, "Fields must not contain null elements.");
        Validate.noNullElements(xmethods, "Methods must not contain null elements.");
        this.targetClass = targetClass;
        this.constructors = xconstructors;
        this.fields = xfields;
        this.methods = xmethods;
        XMember[] members = new XMember[xconstructors.length + xfields.length + xmethods.length];
        System.arraycopy(xconstructors, 0, members, 0, xconstructors.length);
        System.arraycopy(xfields, 0, members, xconstructors.length, xfields.length);
        System.arraycopy(xmethods, 0, members, xconstructors.length + xfields.length, xmethods.length);
        this.checkMembers(members);
        this.members = members;
    }

    public Class<?> getTargetClass() {
        return (Class)this.getAnnotatedElement();
    }

    public XMember<?>[] getMembers() {
        return this.members;
    }

    public XConstructor[] getConstructors() {
        return this.constructors;
    }

    public XField[] getFields() {
        return this.fields;
    }

    public XMethod[] getMethods() {
        return this.methods;
    }

    private void checkMembers(XMember<?>[] members) {
        for (int index = 0; index < members.length; ++index) {
            XMember<?> member = members[index];
            if (member.getMember().getDeclaringClass().isAssignableFrom(this.getTargetClass())) continue;
            throw new IllegalArgumentException("Member [" + member + "] does not belong to the target class [" + this.targetClass + "].");
        }
    }
}

