/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.model.annotation.value;

import org.jvnet.jaxb.annox.model.annotation.value.XAnnotationValueVisitor;
import org.jvnet.jaxb.annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XDynamicAnnotationValue;
import org.jvnet.jaxb.annox.util.Validate;

public class XEnumByNameAnnotationValue<E extends Enum<E>>
extends XDynamicAnnotationValue<E> {
    private final XClassByNameAnnotationValue<E> enumByNameAnnotationValue;
    private final String name;
    private final String enumName;

    public XEnumByNameAnnotationValue(XClassByNameAnnotationValue<E> enumClass, String name) {
        this.enumByNameAnnotationValue = Validate.notNull(enumClass);
        this.name = Validate.notNull(name);
        this.enumName = enumClass.getClassName() + "." + name;
    }

    public String getEnumClassName() {
        return this.enumByNameAnnotationValue.getClassName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected Object getInternalValue() {
        return this.enumName;
    }

    @Override
    public E getValue() {
        Object enumClass = this.enumByNameAnnotationValue.getValue();
        return (E)Enum.valueOf(enumClass, this.name);
    }

    @Override
    public <P> P accept(XAnnotationValueVisitor<P> visitor) {
        return visitor.visit(this);
    }
}

