/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.parser.java.visitor;

import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.lang.reflect.Array;
import org.jvnet.jaxb.annox.model.annotation.value.AbstractBasicXAnnotationValueVisitor;
import org.jvnet.jaxb.annox.model.annotation.value.XAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XArrayClassAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XClassAnnotationValue;
import org.jvnet.jaxb.annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.jaxb.annox.parser.java.visitor.ExpressionVisitor;

public final class ClassExpressionVisitor
extends ExpressionVisitor<XAnnotationValue<Class<?>>> {
    public ClassExpressionVisitor(Class<?> targetClass) {
        super(targetClass);
    }

    @Override
    public XAnnotationValue<Class<?>> visit(ClassExpr n, Void arg) {
        return (XAnnotationValue)n.getType().accept((GenericVisitor)new ExpressionVisitor<XAnnotationValue<Class<?>>>(this.targetClass){

            @Override
            public XAnnotationValue<Class<?>> visit(ClassOrInterfaceType n, Void arg) {
                String className = n.toString();
                try {
                    XClassAnnotationValue classAnnotationValue = new XClassAnnotationValue(Class.forName(className));
                    return classAnnotationValue;
                }
                catch (ClassNotFoundException cnfex) {
                    XClassByNameAnnotationValue classByNameAnnotationValue = new XClassByNameAnnotationValue(className);
                    return classByNameAnnotationValue;
                }
            }

            @Override
            public XAnnotationValue<Class<?>> visit(ArrayType n, Void arg) {
                Type type = n.getElementType();
                XAnnotationValue t = (XAnnotationValue)type.accept((GenericVisitor)this, (Object)arg);
                final int arrayCount = n.getArrayLevel();
                if (arrayCount == 0) {
                    return t;
                }
                return (XAnnotationValue)t.accept(new AbstractBasicXAnnotationValueVisitor<XAnnotationValue<Class<?>>>(){

                    @Override
                    public XAnnotationValue<Class<?>> visitDefault(XAnnotationValue<?> value) {
                        throw new IllegalArgumentException();
                    }

                    @Override
                    public XAnnotationValue<Class<?>> visit(XArrayClassAnnotationValue<?, ?> value) {
                        XArrayClassAnnotationValue arrayClassAnnotationValue = new XArrayClassAnnotationValue(value.getItemClassByNameAnnotationValue(), value.getDimension() + arrayCount);
                        return arrayClassAnnotationValue;
                    }

                    @Override
                    public XAnnotationValue<Class<?>> visit(XClassAnnotationValue<?> value) {
                        Class<?> _class = (Class<?>)value.getValue();
                        for (int index = 0; index < arrayCount; ++index) {
                            _class = Array.newInstance(_class, 0).getClass();
                        }
                        XClassAnnotationValue classAnnotationValue = new XClassAnnotationValue(_class);
                        return classAnnotationValue;
                    }

                    @Override
                    public XAnnotationValue<Class<?>> visit(XClassByNameAnnotationValue<?> value) {
                        XArrayClassAnnotationValue arrayClassAnnotationValue = new XArrayClassAnnotationValue(value, arrayCount);
                        return arrayClassAnnotationValue;
                    }
                });
            }

            @Override
            public XAnnotationValue<Class<?>> visit(VoidType n, Void arg) {
                return new XClassAnnotationValue<Void>(Void.class);
            }

            @Override
            public XAnnotationValue<Class<?>> visit(PrimitiveType n, Void arg) {
                switch (n.getType()) {
                    case BOOLEAN: {
                        return new XClassAnnotationValue<Boolean>(Boolean.TYPE);
                    }
                    case CHAR: {
                        return new XClassAnnotationValue<Character>(Character.TYPE);
                    }
                    case BYTE: {
                        return new XClassAnnotationValue<Byte>(Byte.TYPE);
                    }
                    case SHORT: {
                        return new XClassAnnotationValue<Short>(Short.TYPE);
                    }
                    case INT: {
                        return new XClassAnnotationValue<Integer>(Integer.TYPE);
                    }
                    case LONG: {
                        return new XClassAnnotationValue<Long>(Long.TYPE);
                    }
                    case DOUBLE: {
                        return new XClassAnnotationValue<Double>(Double.TYPE);
                    }
                    case FLOAT: {
                        return new XClassAnnotationValue<Float>(Float.TYPE);
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            public XAnnotationValue<Class<?>> visit(WildcardType n, Void arg) {
                throw new UnsupportedOperationException("Wildcard types are not supported.");
            }
        }, null);
    }
}

