/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.annox.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.jaxb.annox.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationElementUtils {
    private static final Logger LOGGER = Logger.getLogger(AnnotationElementUtils.class.getName());

    private AnnotationElementUtils() {
    }

    public static String getFieldValue(Element annotationElement, String name) {
        String value = null;
        String attribute = annotationElement.getAttribute(name);
        if (!StringUtils.isEmpty(attribute)) {
            value = attribute;
        }
        NodeList nodes = annotationElement.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            value = ((Element)node).getTextContent();
        }
        if ("value".equals(name) && value == null) {
            value = annotationElement.getTextContent();
        }
        return value;
    }

    private static boolean isFieldContainerElement(Node node, String name) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if (name.equals(element.getLocalName()) || name.equals(element.getAttributeNS("urn:jaxb.jvnet.org:annox", "field"))) {
                return true;
            }
            if (name.equals(element.getAttributeNS("http://annox.dev.java.net", "field"))) {
                LOGGER.log(Level.WARNING, "Please migrate your namespace in xsd / xjb from http://annox.dev.java.net to urn:jaxb.jvnet.org:annox");
                return true;
            }
        }
        return false;
    }

    public static Element getFieldElement(Element annotationElement, String name) {
        Node node;
        int index;
        Element value = null;
        NodeList nodes = annotationElement.getChildNodes();
        for (index = 0; index < nodes.getLength(); ++index) {
            node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            Element element = (Element)node;
            NodeList subelements = element.getChildNodes();
            for (int jndex = 0; jndex < subelements.getLength(); ++jndex) {
                Node subnode = subelements.item(jndex);
                if (subnode.getNodeType() != 1) continue;
                value = (Element)subnode;
            }
        }
        if ("value".equals(name) && value == null) {
            for (index = 0; index < nodes.getLength(); ++index) {
                node = nodes.item(index);
                if (node.getNodeType() != 1) continue;
                value = (Element)node;
            }
        }
        return value;
    }

    public static String[] getFieldValues(Element annotationElement, String name) {
        String text;
        ArrayList<String> values = new ArrayList<String>();
        String attribute = annotationElement.getAttribute(name);
        if (!StringUtils.isEmpty(attribute)) {
            String[] entries = attribute.trim().split(" ");
            values.addAll(Arrays.asList(entries));
        }
        NodeList nodes = annotationElement.getChildNodes();
        for (int index = 0; index < nodes.getLength(); ++index) {
            Node node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            Element element = (Element)node;
            String entry = element.getTextContent();
            values.add(entry);
        }
        if ("value".equals(name) && values.isEmpty() && !StringUtils.isEmpty(text = annotationElement.getTextContent())) {
            String[] entries = text.trim().split(" ");
            values.addAll(Arrays.asList(entries));
        }
        return values.isEmpty() ? new String[]{} : values.toArray(new String[values.size()]);
    }

    public static Element[] getFieldElements(Element annotationElement, String name) {
        Node node;
        int index;
        ArrayList<Element> values = new ArrayList<Element>();
        NodeList nodes = annotationElement.getChildNodes();
        for (index = 0; index < nodes.getLength(); ++index) {
            node = nodes.item(index);
            if (!AnnotationElementUtils.isFieldContainerElement(node, name)) continue;
            Element element = (Element)node;
            NodeList subelements = element.getChildNodes();
            for (int jndex = 0; jndex < subelements.getLength(); ++jndex) {
                Node subnode = subelements.item(jndex);
                if (subnode.getNodeType() != 1) continue;
                values.add((Element)subnode);
            }
        }
        if ("value".equals(name) && values.isEmpty()) {
            for (index = 0; index < nodes.getLength(); ++index) {
                node = nodes.item(index);
                if (node.getNodeType() != 1) continue;
                values.add((Element)node);
            }
        }
        return values.isEmpty() ? new Element[]{} : values.toArray(new Element[values.size()]);
    }
}

