/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.xjc.outline.artificial;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Outline;
import java.util.Objects;
import org.jvnet.jaxb.xjc.outline.MClassOutline;
import org.jvnet.jaxb.xjc.outline.MModelOutline;
import org.jvnet.jaxb.xjc.outline.MPropertyAccessor;
import org.jvnet.jaxb.xjc.outline.MPropertyOutline;
import org.jvnet.jaxb.xjc.outline.artificial.AnnotatePropertyVisitor;
import org.jvnet.jaxb.xjc.outline.artificial.PropertyTypeVisitor;
import org.jvnet.jaxb.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb.xml.bind.model.MPropertyInfoVisitor;

public abstract class AbstractPropertyOutline
implements MPropertyOutline {
    protected final Outline outline;
    protected final MModelOutline modelOutline;
    protected final MClassOutline classOutline;
    protected final MPropertyInfo<NType, NClass> propertyInfo;
    protected final JCodeModel codeModel;
    protected final JDefinedClass referenceClass;
    protected final JDefinedClass implementationClass;
    protected final JClass implementationReferenceClass;
    protected final JType type;

    public AbstractPropertyOutline(Outline outline, MClassOutline classOutline, MPropertyInfo<NType, NClass> target) {
        Objects.requireNonNull(outline, "Outline must not be null.");
        Objects.requireNonNull(classOutline, "Class outline must not be null.");
        Objects.requireNonNull(target, "Target property info must not be null.");
        this.outline = outline;
        this.modelOutline = classOutline.getParent();
        this.classOutline = classOutline;
        this.propertyInfo = target;
        this.codeModel = classOutline.getParent().getCode();
        this.referenceClass = classOutline.getReferenceCode();
        this.implementationClass = classOutline.getImplementationCode();
        this.implementationReferenceClass = classOutline.getImplementationReferenceCode();
        this.type = this.generateType();
    }

    protected JType generateType() {
        return (JType)this.propertyInfo.acceptPropertyInfoVisitor((MPropertyInfoVisitor)new PropertyTypeVisitor(this.modelOutline));
    }

    protected void annotate(JAnnotatable annotatable) {
        this.propertyInfo.acceptPropertyInfoVisitor((MPropertyInfoVisitor)new AnnotatePropertyVisitor(annotatable));
    }

    @Override
    public MClassOutline getClassOutline() {
        return this.classOutline;
    }

    public MPropertyInfo<NType, NClass> getTarget() {
        return this.propertyInfo;
    }

    protected abstract class PropertyAccessor
    implements MPropertyAccessor {
        protected final JExpression target;

        public PropertyAccessor(JExpression target) {
            Objects.requireNonNull(target, "Target expression must not be null.");
            this.target = target;
        }

        @Override
        public JType getType() {
            return AbstractPropertyOutline.this.type;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

