/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.util;

import java.lang.reflect.Array;
import java.util.LinkedList;
import org.jvnet.jaxb.plugin.util.Predicate;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] filter(T[] array, Predicate<T> predicate, Class<? extends T> theClass) {
        if (array == null) {
            return null;
        }
        LinkedList<T> list = new LinkedList<T>();
        for (T item : array) {
            if (!predicate.evaluate(item)) continue;
            list.add(item);
        }
        Object[] newArray = (Object[])Array.newInstance(theClass, list.size());
        return list.toArray(newArray);
    }

    public static String toString(Object array) {
        if (array == null) {
            return "{}";
        }
        if (!array.getClass().isArray()) {
            return array.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object item;
            if (i > 0) {
                builder.append(", ");
            }
            if ((item = Array.get(array, i)) == null) {
                builder.append("null");
                continue;
            }
            if (item.getClass().isArray()) {
                builder.append(ArrayUtils.toString(item));
                continue;
            }
            builder.append(item.toString());
        }
        builder.append('}');
        return builder.toString();
    }
}

