/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.codegenerator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.reader.TypeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.jvnet.jaxb2_commons.codemodel.JConditionable;
import org.jvnet.jaxb2_commons.plugin.codegenerator.AbstractCodeGenerator;
import org.jvnet.jaxb2_commons.plugin.codegenerator.Arguments;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerationImplementor;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerator;

public class ObjectCodeGenerator<A extends Arguments<A>>
extends AbstractCodeGenerator<A> {
    public ObjectCodeGenerator(CodeGenerator<A> codeGenerator, CodeGenerationImplementor<A> implementor) {
        super(codeGenerator, implementor);
    }

    @Override
    public void generate(final JBlock block, JType type, Collection<JType> possibleTypes, boolean isAlwaysSet, A arguments) {
        if (possibleTypes.size() <= 1) {
            this.getImplementor().onObject(arguments, block, isAlwaysSet);
        } else {
            JClass jaxbElementClass = this.getCodeModel().ref(JAXBElement.class);
            HashSet<JType> arrays = new HashSet<JType>();
            HashSet<JClass> jaxbElements = new HashSet<JClass>();
            HashSet<JType> otherTypes = new HashSet<JType>();
            for (JType possibleType : possibleTypes) {
                if (possibleType.isArray()) {
                    arrays.add(possibleType);
                    continue;
                }
                if (possibleType instanceof JClass && jaxbElementClass.isAssignableFrom(((JClass)possibleType).erasure())) {
                    jaxbElements.add((JClass)possibleType);
                    continue;
                }
                otherTypes.add(possibleType);
            }
            JConditionable _if = new JConditionable(){
                private JConditional conditional = null;

                @Override
                public JBlock _ifThen(JExpression condition) {
                    this.conditional = this.conditional == null ? block._if(condition) : this.conditional._elseif(condition);
                    return this.conditional._then();
                }

                @Override
                public JBlock _else() {
                    if (this.conditional == null) {
                        return block;
                    }
                    return this.conditional._else();
                }
            };
            if (!jaxbElements.isEmpty()) {
                Set<JType> valueTypes = this.getJAXBElementValueTypes(jaxbElements);
                JType valueType = TypeUtil.getCommonBaseType((JCodeModel)this.getCodeModel(), valueTypes);
                JClass jaxbElementType = jaxbElementClass.narrow(valueType);
                JBlock jaxbElementBlock = _if._ifThen(arguments._instanceof((JType)jaxbElementClass));
                this.getCodeGenerator().generate(jaxbElementBlock, (JType)jaxbElementType, new HashSet<JClass>(jaxbElements), true, arguments.cast("JAXBElement", jaxbElementBlock, (JType)jaxbElementType, true));
            }
            if (!arrays.isEmpty()) {
                for (JType arrayType : arrays) {
                    JBlock arrayBlock = _if._ifThen(arguments._instanceof(arrayType));
                    this.getCodeGenerator().generate(arrayBlock, arrayType, Collections.singleton(arrayType), true, arguments.cast("Array", arrayBlock, arrayType, false));
                }
            }
            if (!otherTypes.isEmpty()) {
                this.getImplementor().onObject(arguments, _if._else(), false);
            }
        }
    }

    private Set<JType> getJAXBElementValueTypes(Collection<JClass> jaxbElements) {
        HashSet<JType> valueTypes = new HashSet<JType>();
        for (JClass jaxbElement : jaxbElements) {
            Object valueType = jaxbElement.getTypeParameters().size() == 1 ? (JType)jaxbElement.getTypeParameters().get(0) : this.getCodeModel().ref(Object.class);
            valueTypes.add((JType)valueType);
        }
        return valueTypes;
    }
}

