/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.simplehashcode;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.codegenerator.AbstractCodeGeneratorPlugin;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerator;
import org.jvnet.jaxb2_commons.plugin.hashcode.Customizations;
import org.jvnet.jaxb2_commons.plugin.simplehashcode.HashCodeArguments;
import org.jvnet.jaxb2_commons.plugin.simplehashcode.HashCodeCodeGenerator;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.FieldUtils;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;

public class SimpleHashCodePlugin
extends AbstractCodeGeneratorPlugin<HashCodeArguments> {
    private int multiplier = 31;

    public String getOptionName() {
        return "XsimpleHashCode";
    }

    public String getUsage() {
        return "  -XsimpleEquals :  Generate reflection-free runtime-free hashCode() methods.\n                    See https://github.com/highsource/jaxb2-basics/wiki/JAXB2-SimpleHashCode-Plugin";
    }

    @Override
    protected QName getSpecialIgnoredElementName() {
        return Customizations.IGNORED_ELEMENT_NAME;
    }

    private int getMultiplier() {
        return this.multiplier;
    }

    @Override
    protected CodeGenerator<HashCodeArguments> createCodeGenerator(JCodeModel codeModel) {
        return new HashCodeCodeGenerator(codeModel);
    }

    @Override
    protected void generate(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod object$hashCode = theClass.method(1, (JType)codeModel.INT, "hashCode");
        object$hashCode.annotate(Override.class);
        JBlock body = object$hashCode.body();
        JExpression currentHashCodeExpression = JExpr.lit((int)1);
        JVar currentHashCode = body.decl((JType)codeModel.INT, "currentHashCode", currentHashCodeExpression);
        Boolean superClassImplementsHashCode = StrategyClassUtils.superClassNotIgnored(classOutline, this.getIgnoring());
        if (superClassImplementsHashCode != null) {
            body.assign((JAssignmentTarget)currentHashCode, currentHashCode.mul(JExpr.lit((int)this.getMultiplier())).plus((JExpression)JExpr._super().invoke("hashCode")));
        }
        if ((declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())).length > 0) {
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
                if (fieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                block.assign((JAssignmentTarget)currentHashCode, currentHashCode.mul(JExpr.lit((int)this.getMultiplier())));
                String propertyName = fieldOutline.getPropertyInfo().getName(true);
                JVar value = block.decl(fieldAccessor.getType(), "the" + propertyName);
                fieldAccessor.toRawValue(block, value);
                JType exposedType = fieldAccessor.getType();
                Set<JType> possibleTypes = FieldUtils.getPossibleTypes(fieldOutline, Aspect.EXPOSED);
                boolean isAlwaysSet = fieldAccessor.isAlwaysSet();
                JExpression hasSetValue = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
                this.getCodeGenerator().generate(block, exposedType, possibleTypes, isAlwaysSet, new HashCodeArguments(codeModel, currentHashCode, this.getMultiplier(), value, hasSetValue));
            }
        }
        body._return((JExpression)currentHashCode);
    }
}

