/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.map_init;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.map_init.Customizations;
import org.jvnet.jaxb2_commons.plugin.map_init.InitClass;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

public class MapInitPlugin
extends AbstractParameterizablePlugin {
    private static final JType[] ABSENT = new JType[0];
    private String mapClass = HashMap.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME);

    public String getOptionName() {
        return "XMapInit";
    }

    public String getUsage() {
        return "Change getter for maps to initialize Maps.";
    }

    public void setMapClass(String mapClass) {
        this.mapClass = mapClass;
    }

    public String getMapClass() {
        return this.mapClass;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, outline.getCodeModel());
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline, JCodeModel codeModel) {
        JDefinedClass theClass = classOutline.implClass;
        this.generateMapInit(classOutline, theClass, codeModel);
    }

    private void generateMapInit(ClassOutline classOutline, JDefinedClass theClass, JCodeModel codeModel) {
        FieldOutline[] declaredFields;
        for (FieldOutline fieldOutline : declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            InitClass initClass;
            String publicName = fieldOutline.getPropertyInfo().getName(true);
            String getterName = "get" + publicName;
            JMethod getter = theClass.getMethod(getterName, ABSENT);
            if (getter == null || !getter.type().erasure().boxify().isAssignableFrom(codeModel.ref(Map.class))) continue;
            JFieldVar field = (JFieldVar)theClass.fields().get(fieldOutline.getPropertyInfo().getName(false));
            CPluginCustomization initClassCustomization = CustomizationUtils.findCustomization((FieldOutline)fieldOutline, (QName)Customizations.INIT_CLASS_ELEMENT_NAME);
            String mapClassName = this.getMapClass();
            if (initClassCustomization != null && (initClass = (InitClass)CustomizationUtils.unmarshall((JAXBContext)Customizations.getContext(), (CPluginCustomization)initClassCustomization)) != null && initClass.getClassName() != null && !"".equals(initClass.getClassName())) {
                mapClassName = initClass.getClassName();
            }
            if (field == null) continue;
            getter.body().pos(0);
            getter.body()._if(field.eq(JExpr._null()))._then().assign((JAssignmentTarget)field, this.newCoreMap(codeModel, mapClassName, getter.type().boxify().getTypeParameters()));
        }
    }

    private JExpression newCoreMap(JCodeModel codeModel, String mapClassName, List<JClass> typeParameters) {
        return JExpr._new((JClass)codeModel.ref(mapClassName).narrow(typeParameters));
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME, Customizations.INIT_CLASS_ELEMENT_NAME);
    }
}

