/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XAnnotationFieldVisitor;
import org.jvnet.annox.model.annotation.field.XAnnotationField;
import org.jvnet.annox.model.annotation.value.XAnnotationValueVisitor;
import org.jvnet.annox.model.annotation.value.XArrayClassAnnotationValue;
import org.jvnet.annox.model.annotation.value.XBooleanAnnotationValue;
import org.jvnet.annox.model.annotation.value.XByteAnnotationValue;
import org.jvnet.annox.model.annotation.value.XCharAnnotationValue;
import org.jvnet.annox.model.annotation.value.XClassAnnotationValue;
import org.jvnet.annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.annox.model.annotation.value.XDoubleAnnotationValue;
import org.jvnet.annox.model.annotation.value.XEnumAnnotationValue;
import org.jvnet.annox.model.annotation.value.XEnumByNameAnnotationValue;
import org.jvnet.annox.model.annotation.value.XFloatAnnotationValue;
import org.jvnet.annox.model.annotation.value.XIntAnnotationValue;
import org.jvnet.annox.model.annotation.value.XLongAnnotationValue;
import org.jvnet.annox.model.annotation.value.XShortAnnotationValue;
import org.jvnet.annox.model.annotation.value.XStringAnnotationValue;
import org.jvnet.annox.model.annotation.value.XXAnnotationAnnotationValue;
import org.jvnet.jaxb2_commons.plugin.annotate.AnnotatingVisitor;
import org.jvnet.jaxb2_commons.util.CodeModelUtils;

public class AnnotatingSingleValueVisitor
implements XAnnotationValueVisitor<JAnnotationUse> {
    private final JCodeModel codeModel;
    private final String name;
    private final JAnnotationUse annotationUse;

    public AnnotatingSingleValueVisitor(JCodeModel codeModel, String name, JAnnotationUse annotationUse) {
        this.codeModel = codeModel;
        this.name = name;
        this.annotationUse = annotationUse;
    }

    public JAnnotationUse visit(XXAnnotationAnnotationValue<?> value) {
        XAnnotation xannotation = value.getXAnnotation();
        JAnnotationUse annotationUse = this.annotationUse.annotationParam(this.name, xannotation.getAnnotationClass());
        for (XAnnotationField field : xannotation.getFieldsList()) {
            field.accept((XAnnotationFieldVisitor)new AnnotatingVisitor(this.codeModel, annotationUse));
        }
        return annotationUse;
    }

    public JAnnotationUse visit(XBooleanAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Boolean)value.getValue()).booleanValue());
    }

    public JAnnotationUse visit(XByteAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Byte)value.getValue()).byteValue());
    }

    public JAnnotationUse visit(XCharAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Character)value.getValue()).charValue());
    }

    public JAnnotationUse visit(XDoubleAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Double)value.getValue()).doubleValue());
    }

    public JAnnotationUse visit(XFloatAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Float)value.getValue()).floatValue());
    }

    public JAnnotationUse visit(XIntAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Integer)value.getValue()).intValue());
    }

    public JAnnotationUse visit(XLongAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Long)value.getValue()).longValue());
    }

    public JAnnotationUse visit(XShortAnnotationValue value) {
        return this.annotationUse.param(this.name, ((Short)value.getValue()).shortValue());
    }

    public JAnnotationUse visit(XStringAnnotationValue value) {
        return this.annotationUse.param(this.name, (String)value.getValue());
    }

    public JAnnotationUse visit(XEnumAnnotationValue<?> value) {
        Enum e = (Enum)value.getValue();
        return this.annotationUse.param(this.name, e);
    }

    public JAnnotationUse visit(XEnumByNameAnnotationValue<?> value) {
        JClass type = (JClass)CodeModelUtils.ref((JCodeModel)this.codeModel, (String)value.getEnumClassName());
        return this.annotationUse.param(this.name, (JExpression)type.staticRef(value.getName()));
    }

    public JAnnotationUse visit(XClassAnnotationValue<?> value) {
        JClass type = this.codeModel.ref((Class)value.getValue());
        return this.annotationUse.param(this.name, (JType)type);
    }

    public JAnnotationUse visit(XClassByNameAnnotationValue<?> value) {
        JType type = CodeModelUtils.ref((JCodeModel)this.codeModel, (String)value.getClassName());
        return this.annotationUse.param(this.name, type);
    }

    public JAnnotationUse visit(XArrayClassAnnotationValue<?, ?> value) {
        JType type = CodeModelUtils.ref((JCodeModel)this.codeModel, (String)value.getItemClassName());
        for (int index = 0; index < value.getDimension(); ++index) {
            type = type.array();
        }
        return this.annotationUse.param(this.name, type);
    }
}

