/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import java.util.Collection;
import org.jvnet.annox.model.XAnnotation;
import org.jvnet.annox.model.XAnnotationFieldVisitor;
import org.jvnet.annox.model.annotation.field.XAnnotationField;
import org.jvnet.jaxb2_commons.plugin.annotate.AnnotatingVisitor;

public class Annotator {
    public static final Annotator INSTANCE = new Annotator();

    public void annotate(JCodeModel codeModel, JAnnotatable annotatable, Collection<XAnnotation<?>> xannotations) {
        for (XAnnotation<?> xannotation : xannotations) {
            if (xannotation == null) continue;
            this.annotate(codeModel, annotatable, xannotation);
        }
    }

    public void annotate(JCodeModel codeModel, JAnnotatable annotatable, XAnnotation<?> xannotation) {
        JClass annotationClass = codeModel.ref(xannotation.getAnnotationClass());
        JAnnotationUse annotationUse = null;
        for (JAnnotationUse annotation : annotatable.annotations()) {
            if (!annotationClass.equals(annotation.getAnnotationClass())) continue;
            annotationUse = annotation;
        }
        if (annotationUse == null) {
            annotationUse = annotatable.annotate(annotationClass);
        }
        XAnnotationFieldVisitor<?> visitor = this.createAnnotationFieldVisitor(codeModel, annotationUse);
        for (XAnnotationField field : xannotation.getFieldsList()) {
            field.accept(visitor);
        }
    }

    protected XAnnotationFieldVisitor<?> createAnnotationFieldVisitor(JCodeModel codeModel, JAnnotationUse annotationUse) {
        AnnotatingVisitor visitor = new AnnotatingVisitor(codeModel, annotationUse);
        return visitor;
    }
}

