/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.xjc.outline.artificial;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Outline;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb2_commons.xjc.outline.MClassOutline;
import org.jvnet.jaxb2_commons.xjc.outline.MModelOutline;
import org.jvnet.jaxb2_commons.xjc.outline.MPropertyAccessor;
import org.jvnet.jaxb2_commons.xjc.outline.MPropertyOutline;
import org.jvnet.jaxb2_commons.xjc.outline.artificial.AnnotatePropertyVisitor;
import org.jvnet.jaxb2_commons.xjc.outline.artificial.PropertyTypeVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;

public abstract class AbstractPropertyOutline
implements MPropertyOutline {
    protected final Outline outline;
    protected final MModelOutline modelOutline;
    protected final MClassOutline classOutline;
    protected final MPropertyInfo<NType, NClass> propertyInfo;
    protected final JCodeModel codeModel;
    protected final JDefinedClass referenceClass;
    protected final JDefinedClass implementationClass;
    protected final JClass implementationReferenceClass;
    protected final JType type;

    public AbstractPropertyOutline(Outline outline, MClassOutline classOutline, MPropertyInfo<NType, NClass> target) {
        Validate.notNull(outline);
        Validate.notNull(classOutline);
        Validate.notNull(target);
        this.outline = outline;
        this.modelOutline = classOutline.getParent();
        this.classOutline = classOutline;
        this.propertyInfo = target;
        this.codeModel = classOutline.getParent().getCode();
        this.referenceClass = classOutline.getReferenceCode();
        this.implementationClass = classOutline.getImplementationCode();
        this.implementationReferenceClass = classOutline.getImplementationReferenceCode();
        this.type = this.generateType();
    }

    protected JType generateType() {
        return this.propertyInfo.acceptPropertyInfoVisitor(new PropertyTypeVisitor(this.modelOutline));
    }

    protected void annotate(JAnnotatable annotatable) {
        this.propertyInfo.acceptPropertyInfoVisitor(new AnnotatePropertyVisitor(annotatable));
    }

    @Override
    public MClassOutline getClassOutline() {
        return this.classOutline;
    }

    @Override
    public MPropertyInfo<NType, NClass> getTarget() {
        return this.propertyInfo;
    }

    protected abstract class PropertyAccessor
    implements MPropertyAccessor {
        protected final JExpression target;

        public PropertyAccessor(JExpression target) {
            Validate.notNull(target);
            this.target = target;
        }

        @Override
        public JType getType() {
            return AbstractPropertyOutline.this.type;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

