/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.wildcard;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.wildcard.Customizations;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardPlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xwildcard";
    }

    public String getUsage() {
        return "Allows specifying the wildcard mode in wildcard properties.";
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        for (CClassInfo classInfo : model.beans().values()) {
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof CReferencePropertyInfo)) continue;
                CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.LAX_ELEMENT_NAME)) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.SKIP_ELEMENT_NAME)) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.STRICT_ELEMENT_NAME)) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.LAX_ELEMENT_NAME)) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                    continue;
                }
                if (CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.SKIP_ELEMENT_NAME)) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                    continue;
                }
                if (!CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.STRICT_ELEMENT_NAME)) continue;
                referencePropertyInfo.setWildcard(WildcardMode.STRICT);
            }
        }
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.LAX_ELEMENT_NAME, Customizations.SKIP_ELEMENT_NAME, Customizations.STRICT_ELEMENT_NAME);
    }
}

