/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.inheritance.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.visitor.GenericVisitor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb2_commons.plugin.inheritance.util.TypeToJTypeConvertingVisitor;

public class JavaTypeParser {
    private final TypeToJTypeConvertingVisitor typeToJTypeConvertingVisitor;

    public JavaTypeParser() {
        this(Collections.emptyMap());
    }

    public JavaTypeParser(Map<String, JClass> knownClasses) {
        Validate.notNull(knownClasses);
        this.typeToJTypeConvertingVisitor = new TypeToJTypeConvertingVisitor(knownClasses);
    }

    public JClass parseClass(String _class, JCodeModel codeModel) {
        JType type = this.parseType(_class, codeModel);
        if (type instanceof JClass) {
            return (JClass)type;
        }
        throw new IllegalArgumentException("Type [" + _class + "] is not a class.");
    }

    private JType parseType(String type, JCodeModel codeModel) {
        String text = "public class Ignored extends " + type + " {}";
        try {
            CompilationUnit compilationUnit = JavaParser.parse((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")), (String)"UTF-8");
            List typeDeclarations = compilationUnit.getTypes();
            TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
            ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)typeDeclaration;
            List _extended = classDeclaration.getExtends();
            ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)_extended.get(0);
            return (JType)classOrInterfaceType.accept((GenericVisitor)this.typeToJTypeConvertingVisitor, (Object)codeModel);
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException("Could not parse the type definition [" + type + "].", pex);
        }
        catch (UnsupportedEncodingException uex) {
            throw new UnsupportedOperationException(uex);
        }
    }

    static {
        JavaParser.setCacheParser((boolean)false);
    }
}

