/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.tools.xjc.outline.ClassOutline;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jvnet.jaxb2_commons.plugin.Ignoring;

public class StrategyClassUtils {
    public static <T> JExpression createStrategyInstanceExpression(JCodeModel codeModel, Class<? extends T> strategyInterface, String strategyClassName) {
        try {
            Class<?> strategyClass = Class.forName(strategyClassName);
            JClass strategyJClass = codeModel.ref(strategyClass);
            try {
                Method getInstanceMethod = strategyClass.getMethod("getInstance", new Class[0]);
                if (getInstanceMethod != null && strategyInterface.isAssignableFrom(getInstanceMethod.getReturnType()) && Modifier.isStatic(getInstanceMethod.getModifiers()) && Modifier.isPublic(getInstanceMethod.getModifiers())) {
                    return strategyJClass.staticInvoke("getInstance");
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                Field instanceField = strategyClass.getField("INSTANCE");
                if (instanceField != null && strategyInterface.isAssignableFrom(instanceField.getType()) && Modifier.isStatic(instanceField.getModifiers()) && Modifier.isPublic(instanceField.getModifiers())) {
                    return strategyJClass.staticRef("INSTANCE");
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            return JExpr._new((JClass)strategyJClass);
        }
        catch (ClassNotFoundException cnfex) {
            JClass strategyJClass = codeModel.ref(strategyClassName);
            return JExpr._new((JClass)strategyJClass);
        }
    }

    public static <T> Boolean superClassImplements(ClassOutline classOutline, Ignoring ignoring, Class<? extends T> theInterface) {
        if (classOutline.target.getBaseClass() != null) {
            if (!ignoring.isIgnored(classOutline.parent().getClazz(classOutline.target.getBaseClass()))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (classOutline.target.getRefBaseClass() != null) {
            try {
                if (theInterface.isAssignableFrom(Class.forName(classOutline.target.getRefBaseClass().fullName()))) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            catch (ClassNotFoundException ignored) {
                return Boolean.TRUE;
            }
        }
        return null;
    }
}

