/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.updatecenter2;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Expand;

public class PackageMojo
extends AbstractMojo {
    @Deprecated
    protected File proto;
    protected File prototype;
    protected File makePkgsDir;
    protected File localRepository;
    @Deprecated
    protected File baseDirectory;
    protected File baseDir;
    @Deprecated
    protected File packageFile;
    protected File destFile;
    @Deprecated
    protected String remoteRepository;
    protected String repourl;
    protected boolean attach;
    protected String python;
    protected MavenProject project;
    protected String[] ostarget;
    protected String manifestFMRI;
    protected File[] manifestFile;
    protected File manifestBase;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File jar = this.locateMakepkgs();
            this.unjar(jar, this.makePkgsDir);
            this.completePkg(this.makePkgsDir);
            this.executeMakePkgs();
        }
        catch (IOException e) {
            throw new MojoExecutionException("makepkgs failed", (Exception)e);
        }
    }

    private void executeMakePkgs() throws MojoExecutionException, IOException {
        boolean createdArchive = false;
        String archiveType = "tgz";
        if (this.repourl == null) {
            this.repourl = this.remoteRepository;
        }
        if (this.destFile == null) {
            this.destFile = this.packageFile;
        }
        if (this.baseDir == null) {
            this.baseDir = this.baseDirectory;
        }
        if (this.prototype == null) {
            this.prototype = this.proto;
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getPythonBin());
        commandLine.add(new File(this.makePkgsDir, "pkg-toolkit/pkg/bin/makepkgs.py").getPath());
        if (this.repourl != null) {
            commandLine.add("-s");
            commandLine.add(this.repourl);
        } else {
            commandLine.add("-d");
            commandLine.add(this.localRepository.getAbsolutePath());
        }
        if (this.destFile != null && !this.repourl.startsWith("http:")) {
            if (this.destFile.getName().endsWith(".tgz")) {
                commandLine.add("-t");
                commandLine.add(this.destFile.getAbsolutePath());
            } else if (this.destFile.getName().endsWith(".zip")) {
                commandLine.add("-z");
                commandLine.add(this.destFile.getAbsolutePath());
                archiveType = "zip";
            } else {
                commandLine.add("-t");
                commandLine.add(this.destFile.getAbsolutePath());
            }
            createdArchive = true;
        }
        commandLine.add("-b");
        commandLine.add(this.baseDir.getAbsolutePath());
        if (this.ostarget != null) {
            for (String os : this.ostarget) {
                commandLine.add("-o");
                commandLine.add(os);
            }
        }
        commandLine.addAll(Arrays.asList("-D", "groupId=" + this.project.getGroupId(), "-D", "artifactId=" + this.project.getArtifactId(), "-D", "version=" + this.project.getVersion()));
        commandLine.add(this.prototype.getAbsolutePath());
        if (this.manifestBase != null) {
            commandLine.add("--manifest-base");
            commandLine.add(this.manifestBase.getAbsolutePath());
        }
        if (this.manifestFMRI != null) {
            commandLine.add("--manifest-fmri");
            commandLine.add(this.manifestFMRI);
        }
        if (this.manifestFile != null) {
            for (File mFile : this.manifestFile) {
                commandLine.add("--manifest-file");
                commandLine.add(mFile.toString());
            }
        }
        this.getLog().debug((CharSequence)("Invoking " + commandLine));
        Execute exec = new Execute();
        exec.setCommandline(commandLine.toArray(new String[commandLine.size()]));
        exec.setWorkingDirectory(this.project.getBasedir());
        if (exec.execute() != 0) {
            throw new MojoExecutionException("makepkgs failed");
        }
        if (createdArchive && this.attach) {
            this.projectHelper.attachArtifact(this.project, archiveType, null, this.destFile);
        }
    }

    private String getPythonBin() {
        if (this.python != null) {
            return this.python;
        }
        for (String candidate : new String[]{"target/pkg-toolkit/pkg/python2.4-minimal/python.exe", "target/pkg-toolkit/pkg/python2.4-minimal/bin/python"}) {
            File f = new File(this.project.getBasedir(), candidate);
            if (!f.exists()) continue;
            return f.getPath();
        }
        return "python";
    }

    private void unjar(File jar, File destDir) {
        this.getLog().info((CharSequence)("Destdir =" + destDir));
        destDir.mkdirs();
        this.getLog().info((CharSequence)("Extracting IPS to " + destDir));
        Expand expand = new Expand();
        expand.setProject(new Project());
        expand.setSrc(jar);
        expand.setDest(destDir);
        expand.execute();
    }

    private void completePkg(File destDir) throws MojoExecutionException {
        String[] command = new String[]{"java", "-jar", destDir.getPath() + "/pkg-toolkit/pkg/lib/pkg-bootstrap.jar"};
        Execute exec = new Execute();
        exec.setCommandline(command);
        exec.setWorkingDirectory(new File(destDir, "pkg-toolkit"));
        try {
            if (exec.execute() != 0) {
                throw new MojoExecutionException("makepkgs failed");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOError", (Exception)e);
        }
    }

    private File locateMakepkgs() throws MalformedURLException {
        String resURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("pkg-toolkit").toString();
        resURL = resURL.substring(4, resURL.lastIndexOf(33));
        return new File(PackageMojo.decode(new URL(resURL).getPath()));
    }

    private static String decode(String s) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%') {
                baos.write(PackageMojo.hexToInt(s.charAt(i + 1)) * 16 + PackageMojo.hexToInt(s.charAt(i + 2)));
                i += 2;
                continue;
            }
            baos.write(ch);
        }
        try {
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static int hexToInt(int ch) {
        return Character.getNumericValue(ch);
    }
}

