/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jwat.arc.ArcFieldParsers;
import org.jwat.arc.ArcRecordBase;
import org.jwat.arc.ArcVersionHeader;
import org.jwat.common.Diagnosis;
import org.jwat.common.Diagnostics;
import org.jwat.common.Digest;
import org.jwat.common.HeaderLineReader;
import org.jwat.common.UriProfile;

public abstract class ArcReader {
    protected boolean bStrict = false;
    protected UriProfile uriProfile;
    protected boolean bBlockDigest = false;
    protected String blockDigestAlgorithm;
    protected String blockDigestEncoding = "base32";
    protected boolean bPayloadDigest = false;
    protected String payloadDigestAlgorithm;
    protected String payloadDigestEncoding = "base32";
    protected int recordHeaderMaxSize;
    protected int payloadHeaderMaxSize;
    protected ArcFieldParsers fieldParsers;
    protected HeaderLineReader lineReader;
    public final Diagnostics<Diagnosis> diagnostics = new Diagnostics();
    protected boolean bIsCompliant = true;
    protected long consumed = 0L;
    protected int records = 0;
    protected int errors = 0;
    protected int warnings = 0;
    public ArcVersionHeader versionHeader;
    protected ArcRecordBase currentRecord = null;
    protected Exception iteratorExceptionThrown;

    protected void init() {
        this.uriProfile = UriProfile.RFC3986;
        this.recordHeaderMaxSize = 8192;
        this.payloadHeaderMaxSize = 32768;
        this.lineReader = HeaderLineReader.getReader();
        this.lineReader.bNameValue = false;
        this.lineReader.encoding = 1;
        this.fieldParsers = new ArcFieldParsers();
    }

    public void reset() {
        this.diagnostics.reset();
        this.bIsCompliant = true;
        this.consumed = 0L;
        this.records = 0;
        this.errors = 0;
        this.warnings = 0;
        this.versionHeader = null;
        this.currentRecord = null;
    }

    public boolean isCompliant() {
        return this.bIsCompliant;
    }

    public abstract boolean isCompressed();

    public void setStrict(boolean bStrict) {
        this.bStrict = bStrict;
    }

    public boolean isStrict() {
        return this.bStrict;
    }

    public void setUriProfile(UriProfile uriProfile) {
        if (uriProfile == null) {
            uriProfile = UriProfile.RFC3986;
        }
        this.uriProfile = uriProfile;
    }

    public UriProfile getUriProfile() {
        return this.uriProfile;
    }

    public boolean getBlockDigestEnabled() {
        return this.bBlockDigest;
    }

    public void setBlockDigestEnabled(boolean enabled) {
        this.bBlockDigest = enabled;
    }

    public boolean getPayloadDigestEnabled() {
        return this.bPayloadDigest;
    }

    public void setPayloadDigestEnabled(boolean enabled) {
        this.bPayloadDigest = enabled;
    }

    public String getBlockDigestAlgorithm() {
        return this.blockDigestAlgorithm;
    }

    public boolean setBlockDigestAlgorithm(String digestAlgorithm) {
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            this.blockDigestAlgorithm = null;
            return true;
        }
        if (Digest.digestAlgorithmLength((String)digestAlgorithm) > 0) {
            this.blockDigestAlgorithm = digestAlgorithm;
            return true;
        }
        return false;
    }

    public String getPayloadDigestAlgorithm() {
        return this.payloadDigestAlgorithm;
    }

    public boolean setPayloadDigestAlgorithm(String digestAlgorithm) {
        if (digestAlgorithm == null || digestAlgorithm.length() == 0) {
            this.payloadDigestAlgorithm = null;
            return true;
        }
        if (Digest.digestAlgorithmLength((String)digestAlgorithm) > 0) {
            this.payloadDigestAlgorithm = digestAlgorithm;
            return true;
        }
        return false;
    }

    public String getBlockDigestEncoding() {
        return this.blockDigestEncoding;
    }

    public void setBlockDigestEncoding(String encodingScheme) {
        this.blockDigestEncoding = encodingScheme != null && encodingScheme.length() > 0 ? encodingScheme.toLowerCase() : null;
    }

    public String getPayloadDigestEncoding() {
        return this.payloadDigestEncoding;
    }

    public void setPayloadDigestEncoding(String encodingScheme) {
        this.payloadDigestEncoding = encodingScheme != null && encodingScheme.length() > 0 ? encodingScheme.toLowerCase() : null;
    }

    public int getRecordHeaderMaxSize() {
        return this.recordHeaderMaxSize;
    }

    public void setRecordHeaderMaxSize(int size) {
        this.recordHeaderMaxSize = size;
    }

    public int getPayloadHeaderMaxSize() {
        return this.payloadHeaderMaxSize;
    }

    public void setPayloadHeaderMaxSize(int size) {
        this.payloadHeaderMaxSize = size;
    }

    public abstract void close();

    protected abstract void recordClosed();

    public abstract long getStartOffset();

    public abstract long getOffset();

    public abstract long getConsumed();

    public abstract ArcRecordBase getNextRecord() throws IOException;

    public abstract ArcRecordBase getNextRecordFrom(InputStream var1, long var2) throws IOException;

    public abstract ArcRecordBase getNextRecordFrom(InputStream var1, long var2, int var4) throws IOException;

    public Exception getIteratorExceptionThrown() {
        return this.iteratorExceptionThrown;
    }

    public Iterator<ArcRecordBase> iterator() {
        return new Iterator<ArcRecordBase>(){
            private ArcRecordBase next;
            private ArcRecordBase current;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    ArcReader.this.iteratorExceptionThrown = null;
                    try {
                        this.next = ArcReader.this.getNextRecord();
                    }
                    catch (IOException e) {
                        ArcReader.this.iteratorExceptionThrown = e;
                    }
                }
                return this.next != null;
            }

            @Override
            public ArcRecordBase next() {
                if (this.next == null) {
                    ArcReader.this.iteratorExceptionThrown = null;
                    try {
                        this.next = ArcReader.this.getNextRecord();
                    }
                    catch (IOException e) {
                        ArcReader.this.iteratorExceptionThrown = e;
                    }
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

