/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

public class Scheme {
    protected static int[] bf;

    protected Scheme() {
    }

    public static boolean startsWithScheme(byte[] bytes) {
        boolean result = false;
        if (bytes != null) {
            int idx = 0;
            boolean bLoop = true;
            while (bLoop) {
                if (idx < bytes.length) {
                    byte c = bytes[idx];
                    if (c == 58) {
                        bLoop = false;
                        if (idx > 0) {
                            result = true;
                        }
                    } else {
                        bLoop = idx > 0 ? (bf[c & 0xFF] & 2) != 0 : (bf[c & 0xFF] & 1) != 0;
                    }
                } else {
                    bLoop = false;
                }
                ++idx;
            }
        }
        return result;
    }

    public static String getScheme(String uri) {
        if (uri != null) {
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            boolean bLoop = true;
            while (bLoop) {
                if (idx < uri.length()) {
                    char c = uri.charAt(idx);
                    if (c < '\u0100') {
                        if (c == ':') {
                            if (idx > 0) {
                                return sb.toString();
                            }
                        } else if (idx > 0) {
                            sb.append(c);
                            bLoop = (bf[c] & 2) != 0;
                        } else {
                            sb.append(c);
                            bLoop = (bf[c] & 1) != 0;
                        }
                    } else {
                        bLoop = false;
                    }
                } else {
                    bLoop = false;
                }
                ++idx;
            }
        }
        return null;
    }

    static {
        int i;
        bf = new int[256];
        String alphas = "abcdefghijklmnopqrstuvwxyz";
        for (i = 0; i < alphas.length(); ++i) {
            Scheme.bf[alphas.charAt((int)i)] = 3;
        }
        alphas = alphas.toUpperCase();
        for (i = 0; i < alphas.length(); ++i) {
            Scheme.bf[alphas.charAt((int)i)] = 3;
        }
        String digits = "1234567890";
        for (int i2 = 0; i2 < digits.length(); ++i2) {
            Scheme.bf[digits.charAt((int)i2)] = 2;
        }
        String scheme = "+-.";
        for (int i3 = 0; i3 < scheme.length(); ++i3) {
            Scheme.bf[scheme.charAt((int)i3)] = 2;
        }
    }
}

