/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DiagnosticsGeneric<T> {
    protected List<T> errors = new LinkedList<T>();
    protected List<T> warnings = new LinkedList<T>();

    public void reset() {
        this.errors.clear();
        this.warnings.clear();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public void addAll(DiagnosticsGeneric<T> diagnostics) {
        if (diagnostics != null && diagnostics != this) {
            this.errors.addAll(diagnostics.errors);
            this.warnings.addAll(diagnostics.warnings);
        }
    }

    public void addError(T d) {
        this.errors.add(d);
    }

    public void addWarning(T d) {
        this.warnings.add(d);
    }

    public List<T> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<T> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }
}

