/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.IOException;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;

public class NewlineParser {
    public boolean bMissingCr = false;
    public boolean bMissingLf = false;
    public boolean bMisplacedCr = false;
    public boolean bMisplacedLf = false;

    public int parseLFs(ByteCountingPushBackInputStream in, Diagnostics diagnostics) throws IOException {
        this.bMissingCr = false;
        this.bMissingLf = false;
        this.bMisplacedCr = false;
        this.bMisplacedLf = false;
        int newlines = 0;
        byte[] buffer = new byte[2];
        boolean bLoop = true;
        block4: while (bLoop) {
            int read = in.read(buffer);
            switch (read) {
                case 1: {
                    if (buffer[0] == 10) {
                        ++newlines;
                        continue block4;
                    }
                    if (buffer[0] == 13) {
                        ++newlines;
                        this.bMissingLf = true;
                        this.bMisplacedCr = true;
                        continue block4;
                    }
                    in.unread(buffer[0]);
                    bLoop = false;
                    continue block4;
                }
                case 2: {
                    if (buffer[0] == 10) {
                        if (buffer[1] == 10) {
                            newlines += 2;
                            continue block4;
                        }
                        if (buffer[1] != 13) {
                            ++newlines;
                            in.unread(buffer[1]);
                            continue block4;
                        }
                        ++newlines;
                        this.bMisplacedCr = true;
                        continue block4;
                    }
                    if (buffer[0] == 13) {
                        if (buffer[1] == 10) {
                            ++newlines;
                            this.bMisplacedCr = true;
                            this.bMisplacedLf = true;
                            continue block4;
                        }
                        ++newlines;
                        this.bMisplacedCr = true;
                        this.bMissingLf = true;
                        in.unread(buffer[1]);
                        continue block4;
                    }
                    in.unread(buffer);
                    bLoop = false;
                    continue block4;
                }
            }
            bLoop = false;
        }
        if (diagnostics != null) {
            if (this.bMissingLf) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Missing LF", "Sequence of LFs"));
            }
            if (this.bMisplacedCr) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Misplaced CR", "Sequence of LFs"));
            }
            if (this.bMisplacedLf) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Misplaced LF", "Sequence of LFs"));
            }
        }
        return newlines;
    }

    public int parseCRLFs(ByteCountingPushBackInputStream in, Diagnostics diagnostics) throws IOException {
        this.bMissingCr = false;
        this.bMissingLf = false;
        this.bMisplacedCr = false;
        this.bMisplacedLf = false;
        int newlines = 0;
        byte[] buffer = new byte[2];
        boolean bLoop = true;
        block4: while (bLoop) {
            int read = in.read(buffer);
            switch (read) {
                case 1: {
                    if (buffer[0] == 10) {
                        ++newlines;
                        this.bMissingCr = true;
                        continue block4;
                    }
                    if (buffer[0] == 13) {
                        ++newlines;
                        this.bMissingLf = true;
                        continue block4;
                    }
                    in.unread(buffer[0]);
                    bLoop = false;
                    continue block4;
                }
                case 2: {
                    if (buffer[0] == 13) {
                        if (buffer[1] == 10) {
                            ++newlines;
                            continue block4;
                        }
                        ++newlines;
                        this.bMissingLf = true;
                        in.unread(buffer[1]);
                        continue block4;
                    }
                    if (buffer[0] == 10) {
                        if (buffer[1] == 13) {
                            ++newlines;
                            this.bMisplacedCr = true;
                            this.bMisplacedLf = true;
                            continue block4;
                        }
                        ++newlines;
                        this.bMissingCr = true;
                        in.unread(buffer[1]);
                        continue block4;
                    }
                    in.unread(buffer);
                    bLoop = false;
                    continue block4;
                }
            }
            bLoop = false;
        }
        if (diagnostics != null) {
            if (this.bMissingCr) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Missing CR", "Sequence of CRLFs"));
            }
            if (this.bMissingLf) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Missing LF", "Sequence of CRLFs"));
            }
            if (this.bMisplacedCr) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Misplaced CR", "Sequence of CRLFs"));
            }
            if (this.bMisplacedLf) {
                diagnostics.addWarning(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "Misplaced LF", "Sequence of CRLFs"));
            }
        }
        return newlines;
    }
}

