/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.security.Security;

public class SecurityProviderTools {
    protected SecurityProviderTools() {
    }

    public static Provider[] getSecurityProviders() {
        return Security.getProviders();
    }

    public static boolean isProviderAvailable(Provider[] providers, String providerName) {
        int len = providers.length;
        boolean bAvail = false;
        for (int idx = 0; idx < len && !bAvail; ++idx) {
            bAvail = providerName.equalsIgnoreCase(providers[idx].getName());
        }
        return bAvail;
    }

    public static boolean loadBCProvider() {
        return SecurityProviderTools.loadProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
    }

    public static boolean loadProvider(String providerName) {
        Class<?> bcProviderClass = null;
        Constructor<?> bcProviderConstructor = null;
        Object bcProviderObject = null;
        try {
            bcProviderClass = SecurityProviderTools.class.getClassLoader().loadClass(providerName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (bcProviderClass != null) {
                bcProviderConstructor = bcProviderClass.getConstructor(new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        try {
            if (bcProviderConstructor != null) {
                bcProviderObject = bcProviderConstructor.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (bcProviderObject != null) {
            Security.addProvider(bcProviderObject);
            return true;
        }
        return false;
    }

    public static void printSecurityProviders(Provider[] providers) {
        for (Provider provider : providers) {
            System.out.println(provider.getName() + " - " + provider.getInfo());
        }
    }
}

