/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TreeOfIntMapper<T> {
    protected IntItem<T> rootItem = new IntItem();
    protected int size = 0;

    public int size() {
        return this.size;
    }

    public void add(T value, int[] arr) {
        int arrIdx = 0;
        int arrLen = arr.length;
        IntItem<T> item = this.rootItem;
        while (arrIdx < arrLen) {
            int listIdx;
            List itemList = item.itemList;
            if (itemList == null) {
                itemList = new LinkedList();
                item.itemList = itemList;
            }
            int arrKey = arr[arrIdx++];
            int listLen = itemList.size();
            item = null;
            for (listIdx = 0; listIdx < listLen; ++listIdx) {
                item = itemList.get(listIdx);
                if (item.key >= arrKey) break;
            }
            if (item != null && item.key == arrKey) continue;
            item = new IntItem();
            item.key = arrKey;
            itemList.add(listIdx, item);
        }
        item.value = value;
        ++this.size;
    }

    public T lookup(int[] arr) {
        int arrIdx = 0;
        int arrLen = arr.length;
        IntItem<T> item = this.rootItem;
        T value = null;
        while (item != null && arrIdx < arrLen) {
            List itemList = item.itemList;
            item = null;
            if (itemList == null) continue;
            int arrKey = arr[arrIdx++];
            int listLen = itemList.size();
            for (int listIdx = 0; listIdx < listLen; ++listIdx) {
                item = itemList.get(listIdx);
                if (item.key >= arrKey) break;
            }
            if (item == null || item.key == arrKey) continue;
            item = null;
        }
        if (item != null) {
            value = item.value;
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator iter = this.rootItem.itemList.iterator();
        ArrayDeque queue = new ArrayDeque();
        queue.push(iter);
        String indent = "  ";
        while (queue.size() > 0) {
            iter = (Iterator)queue.pop();
            indent = indent.substring(2);
            while (iter.hasNext()) {
                IntItem tmpListItem = (IntItem)iter.next();
                if (tmpListItem.value == null) {
                    sb.append(indent + tmpListItem.key);
                } else {
                    sb.append(indent + tmpListItem.key + " " + tmpListItem.value);
                }
                sb.append("\n");
                List itemList = tmpListItem.itemList;
                if (itemList == null) continue;
                queue.push(iter);
                iter = itemList.iterator();
                indent = indent + "  ";
            }
        }
        return sb.toString();
    }

    protected static class IntItem<T> {
        protected int key;
        protected List<IntItem<T>> itemList;
        protected T value;

        protected IntItem() {
        }
    }
}

