/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.net.URISyntaxException;

public class UriProfile {
    public static final int B_ALPHAS = 1;
    public static final int B_DIGITS = 2;
    public static final int B_SCHEME_FIRST = 4;
    public static final int B_SCHEME_FOLLOW = 8;
    public static final int B_UNRESERVED = 16;
    public static final int B_GEN_DELIMS = 32;
    public static final int B_SUB_DELIMS = 64;
    public static final int B_RESERVED = 128;
    public static final int B_PCHAR = 256;
    public static final int B_USERINFO = 512;
    public static final int B_REGNAME = 1024;
    public static final int B_SEGMENT = 2048;
    public static final int B_SEGMENT_NZ = 4096;
    public static final int B_SEGMENT_NZ_NC = 8192;
    public static final int B_PATH = 16384;
    public static final int B_QUERY = 32768;
    public static final int B_FRAGMENT = 65536;
    protected final int[] charTypeMap = new int[256];
    public boolean bAllowRelativeUris;
    public boolean bAllow16bitPercentEncoding;
    public boolean bAllowInvalidPercentEncoding;
    public static int[] asciiHexTab;
    public static char[] hexTab;
    protected static int[] defaultCharTypeMap;
    public static final UriProfile RFC3986;
    public static final UriProfile RFC3986_ABS_16BIT;
    public static final UriProfile RFC3986_ABS_16BIT_LAX;

    public UriProfile() {
        for (int i = 0; i < defaultCharTypeMap.length; ++i) {
            this.charTypeMap[i] = defaultCharTypeMap[i];
        }
        this.bAllowRelativeUris = true;
        this.bAllow16bitPercentEncoding = false;
        this.bAllowInvalidPercentEncoding = false;
    }

    public UriProfile(UriProfile uriProfile) {
        for (int i = 0; i < this.charTypeMap.length; ++i) {
            this.charTypeMap[i] = uriProfile.charTypeMap[i];
        }
        this.bAllowRelativeUris = uriProfile.bAllowRelativeUris;
        this.bAllow16bitPercentEncoding = uriProfile.bAllow16bitPercentEncoding;
        this.bAllowInvalidPercentEncoding = uriProfile.bAllowInvalidPercentEncoding;
    }

    public void charTypeAddAndOr(String chars, int bw_and, int bw_or) {
        UriProfile.charTypeAddAndOr(this.charTypeMap, chars, bw_and, bw_or);
    }

    public int indexOf(int bw_and, String str, int pos) throws URISyntaxException {
        int limit = str.length();
        while (pos < limit) {
            char c = str.charAt(pos);
            if (c < '\u0100') {
                if ((this.charTypeMap[c] & bw_and) != 0) {
                    return pos;
                }
                ++pos;
                continue;
            }
            throw new URISyntaxException(str, "Invalid URI character '" + (Character.isISOControl(c) ? String.format("0x%02x", c) : Character.valueOf(c)) + "'");
        }
        return -1;
    }

    public void validate_first_follow(String str, int bw_and_first, int bw_and_follow) throws URISyntaxException {
        int limit = str.length();
        for (int pos = 0; pos < limit; ++pos) {
            char c = str.charAt(pos);
            if (pos == 0 && (this.charTypeMap[c] & 4) == 0) {
                throw new URISyntaxException(str, "Invalid URI scheme component");
            }
            if ((this.charTypeMap[c] & 8) != 0) continue;
            throw new URISyntaxException(str, "Invalid URI scheme component");
        }
    }

    public String validate_decode(int bw_and, String componentName, String str) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int limit = str.length();
        int decode = 0;
        while (pos < limit) {
            char c;
            if ((c = str.charAt(pos++)) < '\u0100') {
                if ((this.charTypeMap[c] & bw_and) == 0) {
                    if (c == '%') {
                        boolean bValid;
                        int ppos = pos - 1;
                        if (pos < limit) {
                            c = str.charAt(pos);
                            if (c == 'u' || c == 'U') {
                                if (!this.bAllow16bitPercentEncoding) {
                                    if (!this.bAllowInvalidPercentEncoding) {
                                        throw new URISyntaxException(str, "Invalid URI " + componentName + " component - 16-bit percent encoding not allowed");
                                    }
                                    bValid = false;
                                } else {
                                    ++pos;
                                    decode = 4;
                                    bValid = true;
                                }
                            } else {
                                decode = 2;
                                bValid = true;
                            }
                            char decodedC = '\u0000';
                            while (bValid && decode > 0) {
                                if (pos < limit) {
                                    c = str.charAt(pos++);
                                    decodedC = (char)(decodedC << 4);
                                    if (c < '\u0100') {
                                        int tmpC = asciiHexTab[c];
                                        if (tmpC != -1) {
                                            decodedC = (char)(decodedC | tmpC);
                                            --decode;
                                            continue;
                                        }
                                        bValid = false;
                                        continue;
                                    }
                                    bValid = false;
                                    continue;
                                }
                                bValid = false;
                            }
                            if (!bValid && !this.bAllowInvalidPercentEncoding) {
                                throw new URISyntaxException(str, "Invalid URI " + componentName + " component - invalid percent encoding");
                            }
                            sb.append(decodedC);
                        } else {
                            if (!this.bAllowInvalidPercentEncoding) {
                                throw new URISyntaxException(str, "Invalid URI " + componentName + " component - incomplete percent encoding");
                            }
                            bValid = false;
                        }
                        if (bValid) continue;
                        while (ppos < pos) {
                            sb.append(str.charAt(ppos++));
                        }
                        continue;
                    }
                    throw new URISyntaxException(str, "Invalid URI " + componentName + " component - invalid character '" + (Character.isISOControl(c) ? String.format("0x%02x", c) : Character.valueOf(c)) + "'");
                }
                sb.append(c);
                continue;
            }
            throw new URISyntaxException(str, "Invalid URI " + componentName + " component - invalid character '" + (Character.isISOControl(c) ? String.format("0x%02x", c) : Character.valueOf(c)) + "'");
        }
        return sb.toString();
    }

    public static void charTypeAddAndOr(int[] charTypeMap, String chars, int bw_and, int bw_or) {
        int i;
        if (chars != null) {
            for (i = 0; i < chars.length(); ++i) {
                char c = chars.charAt(i);
                charTypeMap[c] = charTypeMap[c] | bw_or;
            }
        }
        if (bw_and != 0) {
            for (i = 0; i < charTypeMap.length; ++i) {
                if ((charTypeMap[i] & bw_and) == 0) continue;
                int n = i;
                charTypeMap[n] = charTypeMap[n] | bw_or;
            }
        }
    }

    static {
        int i;
        int i2;
        asciiHexTab = new int[256];
        hexTab = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String hex = "0123456789abcdef";
        for (i2 = 0; i2 < asciiHexTab.length; ++i2) {
            UriProfile.asciiHexTab[i2] = hex.indexOf(i2);
        }
        hex = hex.toUpperCase();
        for (i2 = 0; i2 < hex.length(); ++i2) {
            UriProfile.asciiHexTab[hex.charAt((int)i2)] = i2;
        }
        defaultCharTypeMap = new int[256];
        String alphas = "abcdefghijklmnopqrstuvwxyz";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, alphas, 0, 1);
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, alphas.toUpperCase(), 0, 1);
        String digits = "1234567890";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, digits, 0, 2);
        String scheme = "+-.";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, null, 1, 12);
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, scheme, 2, 8);
        String unreserved = "-._~";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, unreserved, 3, 16);
        String genDelims = ":/?#[]@";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, genDelims, 0, 160);
        String subDelims = "!$&'()*+,;=";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, subDelims, 0, 192);
        String pchar = ":@";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, pchar, 80, 256);
        String userinfo = ":";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, userinfo, 80, 512);
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, null, 80, 1024);
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, null, 256, 2048);
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, null, 256, 4096);
        String segment_nz_nc = "@";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, segment_nz_nc, 80, 8192);
        String path = "/";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, path, 256, 16384);
        String query = "/?";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, query, 256, 32768);
        String fragment = "/?";
        UriProfile.charTypeAddAndOr(defaultCharTypeMap, fragment, 256, 65536);
        RFC3986 = new UriProfile();
        RFC3986_ABS_16BIT = new UriProfile();
        UriProfile.RFC3986_ABS_16BIT.bAllowRelativeUris = false;
        UriProfile.RFC3986_ABS_16BIT.bAllow16bitPercentEncoding = true;
        UriProfile.RFC3986_ABS_16BIT.bAllowInvalidPercentEncoding = false;
        StringBuilder sb = new StringBuilder("[]");
        for (i = 33; i < 127; ++i) {
            if ((defaultCharTypeMap[i] & 0x10080) != 0 || i == 37) continue;
            sb.append((char)i);
        }
        for (i = 161; i < 255; ++i) {
            sb.append((char)i);
        }
        RFC3986_ABS_16BIT_LAX = new UriProfile();
        UriProfile.RFC3986_ABS_16BIT_LAX.bAllowRelativeUris = false;
        UriProfile.RFC3986_ABS_16BIT_LAX.bAllow16bitPercentEncoding = true;
        UriProfile.RFC3986_ABS_16BIT_LAX.bAllowInvalidPercentEncoding = true;
        RFC3986_ABS_16BIT_LAX.charTypeAddAndOr(sb.toString(), 0, 114688);
        RFC3986_ABS_16BIT_LAX.charTypeAddAndOr("#", 0, 65536);
    }
}

