/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.jwat.common.Diagnosis;
import org.jwat.common.Diagnostics;
import org.jwat.gzip.GzipExtraData;
import org.jwat.gzip.GzipReader;
import org.jwat.gzip.GzipWriter;

public class GzipEntry {
    public static final int WRITE_FROM_BUFFER_SIZE = 8192;
    protected boolean bIsCompliant;
    public long startOffset = -1L;
    public long consumed;
    public int magic;
    public short cm;
    public short flg;
    public long mtime;
    public Date date;
    public short xfl;
    public short os;
    public boolean bFText;
    public Integer xlen;
    public byte[] extraBytes;
    public List<GzipExtraData> extraData = new LinkedList<GzipExtraData>();
    public String fname;
    public String fcomment;
    public Integer crc16;
    public int crc32;
    public int isize;
    public boolean bFhCrc;
    public int comp_crc16;
    public int comp_crc32;
    public int comp_isize;
    public long uncompressed_size;
    public long compressed_size;
    protected InputStream in;
    protected OutputStream out;
    protected GzipReader reader;
    protected GzipWriter writer;
    protected boolean bEof = false;
    public final Diagnostics<Diagnosis> diagnostics = new Diagnostics();

    public GzipEntry() {
        this.cm = (short)8;
        this.os = (short)255;
    }

    public void close() throws IOException {
        if (!this.bEof) {
            this.bEof = true;
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            if (this.reader != null) {
                this.consumed = this.reader.pbin.getConsumed() - this.startOffset;
                this.reader.consumed += this.consumed;
                this.reader = null;
            }
            if (this.writer != null) {
                this.writer = null;
            }
        }
    }

    public boolean isCompliant() {
        return !this.diagnostics.hasErrors() && !this.diagnostics.hasWarnings();
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public InputStream getInputStream() {
        if (this.reader == null) {
            throw new IllegalStateException("Not in reading state!");
        }
        return this.in;
    }

    public OutputStream getOutputStream() {
        if (this.writer == null) {
            throw new IllegalStateException("Not in writing state!");
        }
        return this.out;
    }

    public void writeFrom(InputStream in) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("Not in writing state!");
        }
        if (in == null) {
            throw new IllegalArgumentException("'in' is null!");
        }
        byte[] tmpBuf = new byte[8192];
        try {
            int read;
            while ((read = this.writer.readCompressed(in, tmpBuf, 0, tmpBuf.length)) != -1) {
                this.writer.out.write(tmpBuf, 0, read);
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        this.writer.writeTrailer(this);
        this.out = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("magic: " + this.magic);
        sb.append("gzipmagic: 35615");
        sb.append("cm: " + this.cm);
        sb.append("flg: " + this.flg);
        sb.append("mtime: " + this.mtime);
        sb.append("mtime(date): " + this.date);
        sb.append("xlf: " + this.xfl);
        sb.append("os: " + this.os);
        if (this.xlen != null) {
            sb.append("xlen: " + this.xlen);
        }
        if (this.fname != null) {
            sb.append("fname: " + this.fname);
        }
        if (this.fcomment != null) {
            sb.append("fcomment: " + this.fcomment);
        }
        if (this.crc16 != null) {
            sb.append("crc16: " + this.crc16);
        }
        sb.append("comp_crc16: " + this.comp_crc16);
        sb.append("crc32: " + this.crc32);
        sb.append("isize: " + this.isize);
        sb.append("comp_crc32: " + this.comp_crc32);
        return sb.toString();
    }
}

