/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.gzip;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.ISO8859_1;
import org.jwat.gzip.GzipConstants;
import org.jwat.gzip.GzipEntry;
import org.jwat.gzip.GzipExtraData;

public class GzipReader {
    public static final int SKIP_READ_BUFFER_SIZE = 8192;
    protected byte[] skip_read_buffer = new byte[8192];
    public static final int DEFAULT_INPUT_BUFFER_SIZE = 8192;
    protected ByteCountingPushBackInputStream pbin;
    protected Inflater inf = new Inflater(true);
    protected CRC32 crc = new CRC32();
    protected int lastInput;
    protected byte[] inputBytes;
    protected final ISO8859_1 iso8859_1 = new ISO8859_1();
    protected boolean bIsCompliant = true;
    public final Diagnostics<Diagnosis> diagnostics = new Diagnostics();
    protected int entries = 0;
    protected long startOffset = -1L;
    protected long consumed;
    protected GzipEntry gzipEntry;
    public GzipEntry partialEntry;
    protected byte[] headerBytes = new byte[10];
    protected byte[] xlenBytes = new byte[2];
    protected byte[] fnameBytes;
    protected byte[] fcommentBytes;
    protected byte[] crc16Bytes = new byte[2];
    protected byte[] trailerBytes = new byte[8];

    public static boolean isGzipped(ByteCountingPushBackInputStream pbin) throws IOException {
        if (pbin == null) {
            throw new IllegalArgumentException("'pbin'is null!");
        }
        byte[] magicBytes = new byte[2];
        int magicNumber = -559038737;
        int read = pbin.readFully(magicBytes);
        if (read == 2) {
            magicNumber = (magicBytes[1] & 0xFF) << 8 | magicBytes[0] & 0xFF;
        }
        if (read > 0) {
            pbin.unread(magicBytes, 0, read);
        }
        return magicNumber == 35615;
    }

    public GzipReader(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("in is null!");
        }
        this.pbin = new ByteCountingPushBackInputStream(in, 8192);
        this.inputBytes = new byte[8192];
    }

    public GzipReader(InputStream in, int buffer_size) {
        if (in == null) {
            throw new IllegalArgumentException("in is null!");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("buffer_size is less or equals to zero: " + buffer_size);
        }
        in = new BufferedInputStream(in, buffer_size);
        this.pbin = new ByteCountingPushBackInputStream(in, 8192);
        this.inputBytes = new byte[8192];
    }

    public void close() throws IOException {
        if (this.gzipEntry != null) {
            this.gzipEntry.close();
            this.startOffset = this.pbin.getConsumed();
            this.gzipEntry = null;
        }
        if (this.inf != null) {
            this.inf.end();
            this.inf = null;
        }
        this.pbin = null;
    }

    public boolean isCompliant() {
        return this.bIsCompliant;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getOffset() {
        if (this.pbin != null) {
            return this.pbin.getConsumed();
        }
        return this.consumed;
    }

    public long getConsumed() {
        return this.consumed;
    }

    public GzipEntry getNextEntry() throws IOException {
        int read;
        if (this.gzipEntry != null) {
            this.gzipEntry.close();
            this.gzipEntry = null;
        }
        if ((read = this.pbin.readFully(this.headerBytes)) == 10) {
            try {
                this.crc.reset();
                this.inf.reset();
                this.startOffset = this.pbin.getConsumed() - 10L;
                this.gzipEntry = new GzipEntry();
                this.gzipEntry.reader = this;
                this.gzipEntry.startOffset = this.startOffset;
                this.gzipEntry.magic = (this.headerBytes[1] & 0xFF) << 8 | this.headerBytes[0] & 0xFF;
                this.gzipEntry.cm = (short)(this.headerBytes[2] & 0xFF);
                this.gzipEntry.flg = (short)(this.headerBytes[3] & 0xFF);
                this.gzipEntry.mtime = (this.headerBytes[7] & 0xFF) << 24 | (this.headerBytes[6] & 0xFF) << 16 | (this.headerBytes[5] & 0xFF) << 8 | this.headerBytes[4] & 0xFF;
                this.gzipEntry.date = this.gzipEntry.mtime != 0L ? new Date(this.gzipEntry.mtime * 1000L) : null;
                this.gzipEntry.xfl = (short)(this.headerBytes[8] & 0xFF);
                this.gzipEntry.os = (short)(this.headerBytes[9] & 0xFF);
                this.crc.update(this.headerBytes);
                if (this.gzipEntry.magic != 35615) {
                    this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "Magic Value", new String[]{Integer.toHexString(this.gzipEntry.magic), Integer.toHexString(35615)}));
                }
                if (this.gzipEntry.cm != 8) {
                    this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "Compression Method", new String[]{Integer.toHexString(this.gzipEntry.cm), Integer.toHexString(8)}));
                } else {
                    if ((this.gzipEntry.xfl & 0xF9) != 0) {
                        this.gzipEntry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.RESERVED, "eXtra FLags", new String[]{Integer.toHexString(this.gzipEntry.xfl & 0xF9)}));
                    }
                    if ((this.gzipEntry.xfl & 6) == 6) {
                        this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "eXtra FLags", new String[]{Integer.toHexString(this.gzipEntry.xfl & 6)}));
                    }
                }
                if ((this.gzipEntry.flg & 0xE0) != 0) {
                    this.gzipEntry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.RESERVED, "FLaGs", new String[]{Integer.toHexString(this.gzipEntry.flg & 0xE0)}));
                }
                if (!GzipConstants.osIdxStr.containsKey(this.gzipEntry.os)) {
                    this.gzipEntry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.UNKNOWN, "Operating System", new String[]{Integer.toString(this.gzipEntry.os)}));
                }
                if ((this.gzipEntry.flg & 1) == 1) {
                    this.gzipEntry.bFText = true;
                }
                if ((this.gzipEntry.flg & 4) == 4) {
                    read = this.pbin.read(this.xlenBytes);
                    if (read == 2) {
                        this.gzipEntry.xlen = (this.xlenBytes[1] & 0xFF) << 8 | this.xlenBytes[0] & 0xFF;
                        if (this.gzipEntry.xlen > 0) {
                            this.gzipEntry.extraBytes = new byte[this.gzipEntry.xlen.intValue()];
                            read = this.pbin.readFully(this.gzipEntry.extraBytes);
                            if (read != this.gzipEntry.xlen) {
                                throw new EOFException("Unexpected EOF!");
                            }
                            int idx = 0;
                            boolean b = true;
                            while (b) {
                                if (idx <= this.gzipEntry.extraBytes.length - 4) {
                                    int len;
                                    GzipExtraData extraData = new GzipExtraData();
                                    extraData.si1 = (byte)(this.gzipEntry.extraBytes[idx++] & 0xFF);
                                    extraData.si2 = (byte)(this.gzipEntry.extraBytes[idx++] & 0xFF);
                                    if ((idx += 2) + (len = (this.gzipEntry.extraBytes[idx + 1] & 0xFF) << 8 | this.gzipEntry.extraBytes[idx] & 0xFF) <= this.gzipEntry.extraBytes.length) {
                                        extraData.data = new byte[len];
                                        System.arraycopy(this.gzipEntry.extraBytes, idx, extraData.data, 0, len);
                                        idx += len;
                                        this.gzipEntry.extraData.add(extraData);
                                        continue;
                                    }
                                    b = false;
                                    continue;
                                }
                                b = false;
                            }
                            if (idx != this.gzipEntry.extraBytes.length) {
                                this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "FEXTRA", new String[]{"Invalid structure", "Data truncated"}));
                            }
                        } else {
                            this.gzipEntry.extraBytes = new byte[0];
                        }
                    } else {
                        throw new EOFException("Unexpected EOF!");
                    }
                    this.crc.update(this.xlenBytes);
                    this.crc.update(this.gzipEntry.extraBytes);
                }
                if ((this.gzipEntry.flg & 8) == 8) {
                    this.fnameBytes = this.readZeroTerminated();
                    if (this.fnameBytes == null) {
                        throw new EOFException("Unexpected EOF!");
                    }
                    if (!this.iso8859_1.decode(this.fnameBytes, "")) {
                        this.gzipEntry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.INVALID_ENCODING, "FName", new String[]{this.iso8859_1.decoded, "ISO-8859-1"}));
                    }
                    this.gzipEntry.fname = this.iso8859_1.decoded;
                    this.crc.update(this.fnameBytes);
                    this.crc.update(0);
                }
                if ((this.gzipEntry.flg & 0x10) == 16) {
                    this.fcommentBytes = this.readZeroTerminated();
                    if (this.fcommentBytes == null) {
                        throw new EOFException("Unexpected EOF!");
                    }
                    if (!this.iso8859_1.decode(this.fcommentBytes, "\n")) {
                        this.gzipEntry.diagnostics.addWarning((Object)new Diagnosis(DiagnosisType.INVALID_ENCODING, "FComment", new String[]{this.iso8859_1.decoded, "ISO-8859-1"}));
                    }
                    this.gzipEntry.fcomment = this.iso8859_1.decoded;
                    this.crc.update(this.fcommentBytes);
                    this.crc.update(0);
                }
                if ((this.gzipEntry.flg & 2) == 2) {
                    read = this.pbin.read(this.crc16Bytes);
                    if (read == 2) {
                        this.gzipEntry.bFhCrc = true;
                        this.gzipEntry.crc16 = (this.crc16Bytes[1] & 0xFF) << 8 | this.crc16Bytes[0] & 0xFF;
                    } else {
                        throw new EOFException("Unexpected EOF!");
                    }
                }
                this.gzipEntry.comp_crc16 = (int)this.crc.getValue() & 0xFFFF;
                this.crc.reset();
                if (this.gzipEntry.crc16 != null && this.gzipEntry.crc16 != this.gzipEntry.comp_crc16) {
                    this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "CRC16", new String[]{Integer.toHexString(this.gzipEntry.crc16), Integer.toHexString(this.gzipEntry.comp_crc16)}));
                }
                this.lastInput = 0;
                this.gzipEntry.in = new GzipEntryInputStream(this, this.gzipEntry);
                this.gzipEntry.bIsCompliant = !this.gzipEntry.diagnostics.hasErrors() && !this.gzipEntry.diagnostics.hasWarnings();
                this.bIsCompliant &= this.gzipEntry.bIsCompliant;
                ++this.entries;
            }
            catch (EOFException e) {
                this.partialEntry = this.gzipEntry;
                this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected EOF!"}));
                this.bIsCompliant = false;
                this.gzipEntry = null;
            }
        } else {
            if (this.entries == 0) {
                this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.ERROR_EXPECTED, "GZip file", new String[]{"One or more records"}));
                this.bIsCompliant = false;
            }
            if (this.pbin.read() != -1) {
                this.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected trailing data!"}));
                this.bIsCompliant = false;
            }
        }
        return this.gzipEntry;
    }

    protected byte[] readZeroTerminated() throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream(32);
        while ((b = this.pbin.read()) > 0) {
            out.write(b);
        }
        return b != -1 ? out.toByteArray() : null;
    }

    protected void readTrailer(GzipEntry entry) throws IOException {
        int read = this.pbin.readFully(this.trailerBytes);
        entry.consumed = this.pbin.getConsumed() - entry.startOffset;
        entry.compressed_size = this.inf.getBytesRead();
        entry.uncompressed_size = this.inf.getBytesWritten();
        this.consumed += entry.consumed;
        entry.reader = null;
        if (read == 8) {
            entry.crc32 = (this.trailerBytes[3] & 0xFF) << 24 | (this.trailerBytes[2] & 0xFF) << 16 | (this.trailerBytes[1] & 0xFF) << 8 | this.trailerBytes[0] & 0xFF;
            entry.isize = (this.trailerBytes[7] & 0xFF) << 24 | (this.trailerBytes[6] & 0xFF) << 16 | (this.trailerBytes[5] & 0xFF) << 8 | this.trailerBytes[4] & 0xFF;
            entry.comp_crc32 = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
            entry.comp_isize = (int)(this.inf.getBytesWritten() & 0xFFFFFFFFFFFFFFFFL);
            if (entry.comp_crc32 != entry.crc32) {
                entry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "CRC32", new String[]{Integer.toHexString(entry.crc32), Integer.toHexString(entry.comp_crc32)}));
            }
            if (entry.comp_isize != entry.isize) {
                entry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_EXPECTED, "ISize", new String[]{Long.toString(entry.isize), Long.toString(entry.comp_isize)}));
            }
        } else {
            this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected EOF!"}));
            this.bIsCompliant = false;
        }
        this.gzipEntry.bIsCompliant = !this.gzipEntry.diagnostics.hasErrors() && !this.gzipEntry.diagnostics.hasWarnings();
        this.bIsCompliant &= this.gzipEntry.bIsCompliant;
    }

    protected int readInflated(byte[] b, int off, int len) throws DataFormatException, IOException {
        int inflated = 0;
        while ((inflated = this.inf.inflate(b, off, len)) == 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (this.inf.needsDictionary()) {
                this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected EOF!"}));
                this.bIsCompliant = false;
                throw new DataFormatException("Dictionary needed!");
            }
            if (this.inf.needsInput()) {
                this.lastInput = this.pbin.read(this.inputBytes, 0, this.inputBytes.length);
                if (this.lastInput == -1) {
                    this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected EOF!"}));
                    this.bIsCompliant = false;
                    throw new DataFormatException("Data missing!");
                }
                this.inf.setInput(this.inputBytes, 0, this.lastInput);
                continue;
            }
            this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected EOF!"}));
            this.bIsCompliant = false;
            throw new DataFormatException("Inflater malfunction!");
        }
        return inflated;
    }

    protected static class GzipEntryInputStream
    extends InputStream {
        GzipReader reader;
        GzipEntry gzipEntry;
        boolean bEof = false;
        byte[] singleByteArray = new byte[1];

        public GzipEntryInputStream(GzipReader reader, GzipEntry gzipEntry) {
            this.reader = reader;
            this.gzipEntry = gzipEntry;
        }

        @Override
        public void close() throws IOException {
            while (!this.bEof) {
                this.skip(this.reader.skip_read_buffer.length);
            }
            this.reader = null;
            this.gzipEntry = null;
            this.singleByteArray = null;
            this.bEof = true;
        }

        @Override
        public int available() throws IOException {
            return !this.bEof ? 1 : 0;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.singleByteArray, 0, 1) != -1 ? this.singleByteArray[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read;
            if (this.bEof) {
                return -1;
            }
            try {
                read = this.reader.readInflated(b, off, len);
            }
            catch (DataFormatException e) {
                this.gzipEntry.diagnostics.addError((Object)new Diagnosis(DiagnosisType.INVALID_DATA, "GZip file", new String[]{"Unexpected EOF!"}));
                this.reader.bIsCompliant = false;
                throw new IOException(e);
            }
            if (read != -1) {
                this.reader.crc.update(b, off, read);
            } else {
                int remaining = this.reader.inf.getRemaining();
                if (remaining > this.reader.lastInput) {
                    throw new IOException("Remaining larger than lastInput!");
                }
                this.reader.pbin.unread(this.reader.inputBytes, this.reader.lastInput - remaining, remaining);
                this.bEof = true;
                this.reader.readTrailer(this.gzipEntry);
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.bEof) {
                return 0L;
            }
            long remaining = n;
            long skipped = 0L;
            long readLast = 0L;
            while (remaining > 0L && readLast != -1L) {
                skipped += readLast;
                if ((remaining -= readLast) <= 0L) continue;
                readLast = this.read(this.reader.skip_read_buffer, 0, (int)Math.min(remaining, 8192L));
            }
            return skipped;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized void mark(int readlimit) {
        }

        @Override
        public synchronized void reset() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

